/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.http;

import java.net.URI;
import org.dbrain.binder.http.AbstractHttpConnectorBuilder;
import org.dbrain.binder.http.conf.HttpsConnectorConf;

public class HttpsConnectorBuilder
extends AbstractHttpConnectorBuilder<HttpsConnectorBuilder> {
    private String host;
    private URI keyStore;
    private String keyStorePassword;
    private String keyManagerPassord;

    @Override
    protected HttpsConnectorBuilder self() {
        return this;
    }

    public static HttpsConnectorBuilder from(String serverURI) {
        return new HttpsConnectorBuilder().uri(URI.create(serverURI));
    }

    public static HttpsConnectorBuilder from(URI serverURI) {
        return new HttpsConnectorBuilder().uri(serverURI);
    }

    private HttpsConnectorBuilder() {
    }

    public HttpsConnectorBuilder uri(URI serverURI) {
        if (serverURI != null) {
            int port;
            if (serverURI.getScheme() != null) {
                switch (serverURI.getScheme().toLowerCase()) {
                    case "https": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported scheme: " + serverURI.getScheme());
                    }
                }
            }
            if ((port = serverURI.getPort()) >= 0) {
                this.port(port);
            }
            this.host(serverURI.getHost());
        }
        return this.self();
    }

    public HttpsConnectorBuilder host(String host) {
        this.host = host;
        return this.self();
    }

    public HttpsConnectorBuilder keystore(URI keyStoreUri, String keyStorePassword, String keyManagerPassord) {
        this.keyStore = keyStoreUri;
        this.keyStorePassword = keyStorePassword;
        this.keyManagerPassord = keyManagerPassord;
        return this.self();
    }

    public HttpsConnectorConf build() {
        Integer finalPort = this.getPort();
        finalPort = finalPort != null ? finalPort : 443;
        HttpsConnectorConf result = new HttpsConnectorConf();
        result.setPort(finalPort);
        result.setHost(this.host);
        result.setKeyStore(this.keyStore);
        result.setKeyManagerPassord(this.keyManagerPassord);
        result.setKeyStorePassword(this.keyStorePassword);
        return result;
    }
}

