/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.http;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.dbrain.binder.http.conf.ServletAppSecurityConf;
import org.dbrain.binder.http.conf.ServletConf;
import org.dbrain.binder.http.conf.ServletContextConf;
import org.dbrain.binder.http.conf.ServletFilterConf;
import org.dbrain.binder.http.conf.WebSocketServerConf;

public class ServletContextBuilder {
    protected String contextPath;
    protected List<ServletConf> servlets = new ArrayList<ServletConf>();
    protected List<WebSocketServerConf> webSockets = new ArrayList<WebSocketServerConf>();
    protected List<ServletFilterConf> filters = new ArrayList<ServletFilterConf>();
    protected ServletAppSecurityConf security;

    public ServletContextBuilder(String contextPath) {
        this.contextPath(contextPath);
    }

    public ServletContextBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public ServletContextBuilder serve(ServletConf servletDef) {
        if (servletDef != null) {
            this.servlets.add(servletDef);
        }
        return this;
    }

    public ServletContextBuilder serve(WebSocketServerConf wsd) {
        if (wsd != null) {
            this.webSockets.add(wsd);
        }
        return this;
    }

    public ServletContextBuilder filter(String pathSpec, Filter filter) {
        this.filters.add(ServletFilterConf.of(pathSpec, filter));
        return this;
    }

    public void security(ServletAppSecurityConf security) {
        this.security = security;
    }

    public ServletContextConf build() {
        return new ServletContextConf(this.contextPath, this.servlets, this.filters, this.webSockets, this.security);
    }
}

