/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.app;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Named;
import org.dbrain.binder.app.App;
import org.dbrain.binder.app.Binder;
import org.dbrain.binder.app.Module;
import org.dbrain.binder.directory.Qualifiers;
import org.dbrain.binder.directory.ServiceKey;
import org.dbrain.binder.system.app.SimpleBinder;
import org.dbrain.binder.system.app.SimpleBindingContext;
import org.dbrain.binder.system.http.server.HttpStandardScopeComponent;
import org.dbrain.binder.system.http.webapp.WebAppComponent;
import org.dbrain.binder.system.lifecycle.BaseClassAnalyzer;
import org.dbrain.binder.system.scope.StandardScopeComponent;
import org.dbrain.binder.system.txs.TransactionComponent;
import org.dbrain.binder.system.util.AnnotationBuilder;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class AppImpl
implements App {
    private static final ServiceLocatorFactory serviceLocatorFactory = ServiceLocatorFactory.getInstance();
    private final String name;
    private final ServiceLocator delegate;
    private final ThreadLocal<SimpleBinder> currentBinder = new ThreadLocal();

    public AppImpl() {
        this(UUID.randomUUID().toString());
    }

    public AppImpl(String name) {
        this.name = name;
        this.delegate = serviceLocatorFactory.create(name);
        ServiceLocatorUtilities.addClasses((ServiceLocator)this.delegate, (Class[])new Class[]{BaseClassAnalyzer.class});
        this.delegate.setDefaultClassAnalyzerName("BINDER_ANALYZER_NAME");
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.delegate, (Object)this);
        this.configure((Binder binder) -> binder.bindService(SimpleBindingContext.class).to((Type)((Object)Binder.BindingContext.class)).to((Type)((Object)SimpleBindingContext.class)).providedBy(() -> this.currentBinder.get().getBindingContext()));
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)this.delegate);
        this.configure((Binder binder) -> {
            binder.bindComponent(TransactionComponent.class);
            binder.bindComponent(StandardScopeComponent.class);
        });
        this.configure((Binder binder) -> {
            binder.bindComponent(HttpStandardScopeComponent.class);
            binder.bindComponent(WebAppComponent.class);
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void configure(Module configurator) {
        try {
            SimpleBinder binder = this.startConfiguration();
            configurator.configure(binder);
            this.commitConfiguration();
        }
        catch (Exception e) {
            throw new MultiException((Throwable)e);
        }
    }

    @Override
    public void configure(Class<? extends Module> ... modules) {
        for (Class<? extends Module> module : modules) {
            this.configure(this.getOrCreateInstance(module));
        }
    }

    private SimpleBinder startConfiguration() {
        if (this.currentBinder.get() != null) {
            throw new IllegalStateException("Cannot configure twice on the same thread at the same time.");
        }
        this.currentBinder.set(new SimpleBinder(this, new SimpleBindingContext()));
        return this.currentBinder.get();
    }

    private void commitConfiguration() {
        if (this.currentBinder.get() == null) {
            throw new IllegalStateException("No configuration to commit.");
        }
        try {
            this.currentBinder.get().commit();
        }
        finally {
            this.currentBinder.set(null);
        }
    }

    @Override
    public <T> T locate(Class<T> serviceClass) {
        return (T)this.delegate.getService(serviceClass, new Annotation[0]);
    }

    @Override
    public <T> T locate(Class<T> serviceClass, String name) {
        return (T)this.delegate.getService(serviceClass, name, new Annotation[0]);
    }

    @Override
    public <T> T locate(Class<T> serviceClass, Class<? extends Annotation> qualifier) {
        return (T)this.delegate.getService(serviceClass, new Annotation[]{AnnotationBuilder.of(qualifier)});
    }

    @Override
    public <T> T locate(ServiceKey<T> serviceKey) {
        Qualifiers qualifiers = serviceKey.getQualifiers();
        Object result = qualifiers.size() > 0 ? this.delegate.getService(serviceKey.getServiceType(), qualifiers.toArray()) : this.delegate.getService(serviceKey.getServiceType(), new Annotation[0]);
        return (T)result;
    }

    @Override
    public <T> T locate(Class<T> serviceClass, Qualifiers qualifiers) {
        Object result = qualifiers.size() > 0 ? this.delegate.getService(serviceClass, qualifiers.toArray()) : this.delegate.getService(serviceClass, new Annotation[0]);
        return (T)result;
    }

    @Override
    public <T> T getInstance(Class<T> serviceClass) {
        T result = this.locate(serviceClass);
        Objects.requireNonNull(result, "Service of class " + serviceClass.getName() + " is not found in application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> T getInstance(Class<T> serviceClass, String name) {
        T result = this.locate(serviceClass, name);
        Objects.requireNonNull(result, "Service of class " + serviceClass.getName() + " is not found in application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> T getInstance(Class<T> serviceClass, Class<? extends Annotation> qualifier) {
        T result = this.locate(serviceClass, qualifier);
        Objects.requireNonNull(result, "Service of class " + serviceClass.getName() + " is not found in application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> T getInstance(ServiceKey<T> serviceKey) {
        T result = this.locate(serviceKey);
        Objects.requireNonNull(result, "Service of class " + serviceKey.getServiceType() + " is not found in application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> T getInstance(Class<T> serviceClass, Qualifiers qualifiers) {
        T result = this.locate(serviceClass, qualifiers);
        Objects.requireNonNull(result, "Service of class " + serviceClass + " is not found in application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> T getOrCreateInstance(Class<T> serviceClass) {
        return this.getOrCreateInstance(ServiceKey.of(serviceClass));
    }

    @Override
    public <T> T getOrCreateInstance(ServiceKey<T> serviceKey) {
        Object result = this.locate(serviceKey);
        if (result == null && serviceKey.getQualifiers().size() == 0) {
            result = this.delegate.createAndInitialize(serviceKey.getServiceClass());
        }
        Objects.requireNonNull(result, "Cannot create instance of " + serviceKey.getServiceClass().getName() + " using application " + this.getName() + ".");
        return result;
    }

    @Override
    public <T> List<T> listServices(Class<T> serviceClass) {
        return this.delegate.getAllServices(serviceClass, new Annotation[0]);
    }

    @Override
    public <T> List<T> listServices(Class<T> serviceClass, String name) {
        return this.delegate.getAllServices(serviceClass, new Annotation[]{AnnotationBuilder.of(Named.class, name)});
    }

    @Override
    public <T> List<T> listServices(Class<T> serviceClass, Class<? extends Annotation> qualifier) {
        return this.delegate.getAllServices(serviceClass, new Annotation[]{AnnotationBuilder.of(qualifier)});
    }

    @Override
    public <T> List<T> listServices(Class<T> serviceClass, Qualifiers qualifiers) {
        return this.delegate.getAllServices(serviceClass, qualifiers.toArray());
    }

    @Override
    public void close() throws Exception {
        this.delegate.shutdown();
    }
}

