/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.app;

import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.dbrain.binder.app.App;
import org.dbrain.binder.app.Binder;
import org.dbrain.binder.app.Component;
import org.dbrain.binder.app.ServiceConfigurator;
import org.dbrain.binder.system.app.BindingBuilderImpl;
import org.dbrain.binder.system.app.SimpleBindingContext;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;

public class SimpleBinder
implements Binder {
    private final App app;
    private final SimpleBindingContext bindingStack;
    private DynamicConfiguration dc;

    @Inject
    public SimpleBinder(App app, SimpleBindingContext bindingStack) {
        this.app = app;
        this.bindingStack = bindingStack;
        this.dc = app.getInstance(DynamicConfigurationService.class).createDynamicConfiguration();
    }

    @Override
    public <T> ServiceConfigurator<T> bindService(Class<T> implementationClass) {
        return new BindingBuilderImpl<T>(this.app, this.bindingStack, this.dc, implementationClass);
    }

    @Override
    public <T> ServiceConfigurator<T> bindService(T implementation) {
        return this.bindService((T)implementation.getClass()).providedBy((Class<?>)implementation);
    }

    @Override
    public <T extends Component> T bindComponent(Class<T> componentClass) {
        return (T)((Component)this.app.getOrCreateInstance(componentClass));
    }

    public SimpleBindingContext getBindingContext() {
        return this.bindingStack;
    }

    public void commit() {
        List<Consumer<Binder>> binders = this.bindingStack.empty();
        while (binders != null) {
            for (Consumer<Binder> b : binders) {
                b.accept(this);
            }
            binders = this.bindingStack.empty();
        }
        this.dc.commit();
    }
}

