/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.jetty.websocket;

import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.dbrain.binder.system.jetty.websocket.JsrScopedSession;
import org.dbrain.binder.system.scope.RequestScopeContext;
import org.dbrain.binder.system.scope.SessionScopeContext;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;

public class JsrScopedSessionFactory
implements SessionFactory {
    private AtomicLong idgen = new AtomicLong(0L);
    private ClientContainer container;
    private SessionListener[] listeners;
    private final RequestScopeContext requestScopeContext;
    private final SessionScopeContext sessionScopeContext;

    @Inject
    public JsrScopedSessionFactory(RequestScopeContext requestScopeContext, SessionScopeContext sessionScopeContext) {
        this.requestScopeContext = requestScopeContext;
        this.sessionScopeContext = sessionScopeContext;
    }

    public void configure(ClientContainer container, SessionListener ... sessionListeners) {
        this.container = container;
        this.listeners = sessionListeners;
    }

    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new JsrScopedSession(this.requestScopeContext, this.sessionScopeContext, connection, this.container, this.getNextId(), requestURI, websocket, this.listeners);
    }

    public String getNextId() {
        return String.format("websocket-%d", this.idgen.incrementAndGet());
    }

    public boolean supports(EventDriver websocket) {
        return websocket instanceof AbstractJsrEventDriver;
    }
}

