/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;

public class ContextRegistry
implements AutoCloseable {
    private final Map<ActiveDescriptor, Object> managedObjects = new HashMap<ActiveDescriptor, Object>();

    protected <T> void addEntry(ActiveDescriptor key, Object e) {
        this.managedObjects.put(key, e);
    }

    public synchronized <T> T findOrCreate(ActiveDescriptor<T> key, ServiceHandle<?> root) {
        if (this.managedObjects.containsKey(key)) {
            return (T)this.managedObjects.get(key);
        }
        Object value = key.create(root);
        this.addEntry(key, value);
        return (T)value;
    }

    public synchronized boolean containsKey(ActiveDescriptor key) {
        return this.managedObjects.containsKey(key);
    }

    public synchronized void destroyOne(ActiveDescriptor key) {
        Object value = this.managedObjects.remove(key);
        if (value != null) {
            key.dispose(value);
        }
    }

    @Override
    public synchronized void close() {
        List exceptions = null;
        for (Map.Entry<ActiveDescriptor, Object> entry : new ArrayList<Map.Entry<ActiveDescriptor, Object>>(this.managedObjects.entrySet())) {
            if (entry.getValue() == null) continue;
            entry.getKey().dispose(entry.getValue());
        }
        this.managedObjects.clear();
        if (exceptions != null) {
            throw new MultiException(exceptions);
        }
    }
}

