/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.txs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.dbrain.binder.system.lifecycle.ContextRegistry;
import org.dbrain.binder.system.txs.TransactionMember;
import org.dbrain.binder.txs.Transaction;
import org.dbrain.binder.txs.TransactionException;
import org.dbrain.binder.txs.TransactionState;
import org.dbrain.binder.txs.exceptions.CommitFailedException;
import org.dbrain.binder.txs.exceptions.NoTransactionException;
import org.glassfish.hk2.api.ActiveDescriptor;

public class TransactionImpl
extends ContextRegistry
implements Transaction {
    private final Iterable<TransactionMember.Wrapper> factories;
    private final Runnable afterClose;
    private TransactionState state = TransactionState.ACTIVE;
    private LinkedList<TransactionMember> members = new LinkedList();

    public TransactionImpl(Iterable<TransactionMember.Wrapper> factories, Runnable afterClose) {
        this.factories = factories;
        this.afterClose = afterClose;
    }

    @Override
    public synchronized TransactionState getStatus() {
        return this.state;
    }

    @Override
    protected synchronized void addEntry(ActiveDescriptor key, Object value) {
        super.addEntry(key, value);
        if (value instanceof TransactionMember) {
            this.members.addFirst((TransactionMember)value);
        } else if (value != null) {
            for (TransactionMember.Wrapper factory : this.factories) {
                if (!factory.forClass().isAssignableFrom(value.getClass())) continue;
                this.members.addFirst(factory.wrap(value));
            }
        }
    }

    private List<TransactionMember> listMemberForCommit() {
        return this.members != null ? new ArrayList<TransactionMember>(this.members) : new ArrayList();
    }

    @Override
    public synchronized void commit() throws TransactionException {
        if (this.state != TransactionState.ACTIVE) {
            throw new NoTransactionException();
        }
        Throwable error = null;
        int commitIdx = 0;
        if (this.members != null) {
            List<TransactionMember> memberToCommit = this.listMemberForCommit();
            int totalToCommit = memberToCommit.size();
            try {
                for (TransactionMember member : memberToCommit) {
                    member.flush();
                }
                while (commitIdx < totalToCommit) {
                    memberToCommit.get(commitIdx).commit();
                    ++commitIdx;
                }
            }
            catch (Throwable t) {
                error = t;
            }
            if (commitIdx < totalToCommit) {
                this.rollback(memberToCommit, commitIdx);
            }
        }
        if (error != null) {
            this.state = commitIdx > 0 ? TransactionState.PARTIAL_ROLLBACK : TransactionState.ROLLBACK;
            throw new CommitFailedException(error);
        }
        this.state = TransactionState.COMMIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(List<TransactionMember> members, int idx) throws TransactionException {
        Preconditions.checkNotNull(members);
        int total = members.size();
        Preconditions.checkArgument((idx <= total ? 1 : 0) != 0);
        while (idx < total) {
            try {
                members.get(idx).rollback();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                ++idx;
            }
        }
    }

    @Override
    public synchronized void rollback() throws TransactionException {
        if (this.state != TransactionState.ACTIVE) {
            throw new NoTransactionException();
        }
        if (this.members != null) {
            this.rollback(this.members, 0);
        }
        this.state = TransactionState.ROLLBACK;
    }

    @Override
    public synchronized void close() {
        try {
            if (this.state == TransactionState.ACTIVE) {
                this.rollback();
            }
        }
        finally {
            super.close();
            if (this.afterClose != null) {
                this.afterClose.run();
            }
        }
    }
}

