/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.txs;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.dbrain.binder.lifecycle.TransactionScoped;
import org.dbrain.binder.system.txs.TransactionImpl;
import org.dbrain.binder.system.txs.TransactionMember;
import org.dbrain.binder.txs.Transaction;
import org.dbrain.binder.txs.TransactionControl;
import org.dbrain.binder.txs.TransactionState;
import org.dbrain.binder.txs.exceptions.NoTransactionException;
import org.dbrain.binder.txs.exceptions.TransactionAlreadyStartedException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;

public class TransactionManager
implements TransactionControl,
Context<TransactionScoped> {
    private final ServiceLocator sl;
    private final Iterable<TransactionMember.Wrapper> memberFactories;
    private final ThreadLocal<TransactionImpl> transaction = new ThreadLocal();

    @Inject
    public TransactionManager(ServiceLocator sl, IterableProvider<TransactionMember.Wrapper> memberFactory) {
        this.sl = sl;
        this.memberFactories = memberFactory;
    }

    @Override
    public Transaction current() {
        return this.transaction.get();
    }

    @Override
    public Transaction start() {
        TransactionImpl tx = this.transaction.get();
        if (tx != null) {
            throw new TransactionAlreadyStartedException();
        }
        tx = new TransactionImpl(this.memberFactories, () -> this.transaction.set(null));
        this.transaction.set(tx);
        return tx;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public <T> T findOrCreate(ActiveDescriptor<T> key, ServiceHandle<?> root) {
        TransactionImpl tx = this.transaction.get();
        if (tx == null) {
            throw new NoTransactionException();
        }
        return tx.findOrCreate(key, root);
    }

    public boolean containsKey(ActiveDescriptor key) {
        TransactionImpl tx = this.transaction.get();
        if (tx == null) {
            throw new NoTransactionException();
        }
        return tx.containsKey(key);
    }

    public void destroyOne(ActiveDescriptor<?> key) {
        TransactionImpl tx = this.transaction.get();
        if (tx == null) {
            throw new NoTransactionException();
        }
        tx.destroyOne(key);
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public boolean isActive() {
        TransactionImpl tx = this.transaction.get();
        return tx != null && tx.getStatus() == TransactionState.ACTIVE;
    }

    public void shutdown() {
    }
}

