/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AnnotationBuilder<A extends Annotation> {
    private final Class<A> annotationClass;
    private final Map<String, Property> properties;

    public static <U extends Annotation> U of(Class<U> annotationClass) {
        return AnnotationBuilder.from(annotationClass).build();
    }

    public static <U extends Annotation> U of(Class<U> annotationClass, Object value) {
        return AnnotationBuilder.from(annotationClass).value(value).build();
    }

    public static <U extends Annotation> AnnotationBuilder<U> from(Class<U> annotationClass) {
        return new AnnotationBuilder<U>(annotationClass);
    }

    private AnnotationBuilder(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
        this.properties = AnnotationBuilder.getProperties(annotationClass);
    }

    private static <A extends Annotation> LinkedHashMap<String, Property> getProperties(Class<A> annotationType) {
        return AccessController.doPrivileged(() -> {
            LinkedHashMap<String, Property> result = new LinkedHashMap<String, Property>();
            AccessibleObject[] methods = annotationType.getDeclaredMethods();
            AccessibleObject.setAccessible(methods, true);
            for (AccessibleObject method : methods) {
                Property property = new Property((Method)method);
                result.put(property.getName(), property);
            }
            return result;
        });
    }

    public AnnotationBuilder<A> value(String name, Object value) {
        Objects.requireNonNull(name);
        Property prop = this.properties.get(name);
        if (prop == null) {
            throw new IllegalArgumentException(name);
        }
        prop.setValue(value);
        return this;
    }

    public AnnotationBuilder<A> value(Object value) {
        return this.value("value", value);
    }

    private int getHashCode() {
        int hashCode = 0;
        for (Map.Entry<String, Property> property : this.properties.entrySet()) {
            hashCode += 127 * property.getKey().hashCode() ^ property.getValue().toHashCode();
        }
        return hashCode;
    }

    public A build() {
        for (Property p : this.properties.values()) {
            if (p.getValue() != null) continue;
            throw new IllegalArgumentException("Missing " + p.getName() + " value.");
        }
        return new Proxy<A>(this.annotationClass, this.properties, this.getHashCode()).getProxy();
    }

    static final class Property {
        private final String name;
        private final Class<?> type;
        private final Method method;
        private Object value;

        public Property(Method method) {
            this.name = method.getName();
            this.type = method.getReturnType();
            this.method = method;
            this.value = method.getDefaultValue();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setValue(Object value) {
            if (!(value == null || this.type.isAssignableFrom(value.getClass()) || this.type == Boolean.TYPE && value.getClass() == Boolean.class || this.type == Byte.TYPE && value.getClass() == Byte.class || this.type == Character.TYPE && value.getClass() == Character.class || this.type == Double.TYPE && value.getClass() == Double.class || this.type == Float.TYPE && value.getClass() == Float.class || this.type == Integer.TYPE && value.getClass() == Integer.class || this.type == Long.TYPE && value.getClass() == Long.class || this.type == Short.TYPE && value.getClass() == Short.class)) {
                throw new IllegalArgumentException("Cannot assign value of type '" + value.getClass().getName() + "' to property '" + this.name + "' of type '" + this.type.getName() + "'");
            }
            this.value = value;
        }

        protected int toHashCode() {
            if (this.value == null) {
                return 0;
            }
            if (!this.type.isArray()) {
                return this.value.hashCode();
            }
            if (this.type == byte[].class) {
                return Arrays.hashCode((byte[])this.value);
            }
            if (this.type == short[].class) {
                return Arrays.hashCode((short[])this.value);
            }
            if (this.type == int[].class) {
                return Arrays.hashCode((int[])this.value);
            }
            if (this.type == long[].class) {
                return Arrays.hashCode((long[])this.value);
            }
            if (this.type == char[].class) {
                return Arrays.hashCode((char[])this.value);
            }
            if (this.type == float[].class) {
                return Arrays.hashCode((float[])this.value);
            }
            if (this.type == double[].class) {
                return Arrays.hashCode((double[])this.value);
            }
            if (this.type == boolean[].class) {
                return Arrays.hashCode((boolean[])this.value);
            }
            return Arrays.hashCode((Object[])this.value);
        }

        protected String valueToString() {
            if (!this.type.isArray()) {
                return String.valueOf(this.value);
            }
            Class<?> arrayType = this.type.getComponentType();
            if (arrayType == Boolean.TYPE) {
                return Arrays.toString((boolean[])this.value);
            }
            if (arrayType == Byte.TYPE) {
                return Arrays.toString((byte[])this.value);
            }
            if (arrayType == Character.TYPE) {
                return Arrays.toString((char[])this.value);
            }
            if (arrayType == Double.TYPE) {
                return Arrays.toString((double[])this.value);
            }
            if (arrayType == Float.TYPE) {
                return Arrays.toString((float[])this.value);
            }
            if (arrayType == Integer.TYPE) {
                return Arrays.toString((int[])this.value);
            }
            if (arrayType == Long.TYPE) {
                return Arrays.toString((long[])this.value);
            }
            if (arrayType == Short.TYPE) {
                return Arrays.toString((short[])this.value);
            }
            return Arrays.toString((Object[])this.value);
        }
    }

    private static final class Proxy<A extends Annotation>
    implements Annotation,
    InvocationHandler {
        private final Class<A> annotationType;
        private final Map<String, Property> properties;
        private final int hashCode;
        private final A proxy;

        public Proxy(Class<A> annotationType, Map<String, Property> properties, int hashCode) {
            this.annotationType = annotationType;
            this.properties = properties;
            this.hashCode = hashCode;
            this.proxy = (Annotation)annotationType.cast(java.lang.reflect.Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)this));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (this.properties.containsKey(name)) {
                return this.properties.get(name).getValue();
            }
            return method.invoke((Object)this, args);
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.annotationType.isInstance(obj)) {
                return false;
            }
            for (Property property : this.properties.values()) {
                if (!this.properties.containsKey(property.getName())) {
                    return false;
                }
                Method m = property.getMethod();
                try {
                    Object thatValue;
                    Object thisValue = property.getValue();
                    if (Objects.deepEquals(thisValue, thatValue = m.invoke(obj, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("@").append(this.annotationType.getName()).append('(');
            int counter = 0;
            for (Map.Entry<String, Property> property : this.properties.entrySet()) {
                if (counter > 0) {
                    sb.append(", ");
                }
                sb.append(property.getKey()).append('=').append(property.getValue().valueToString());
                ++counter;
            }
            return sb.append(')').toString();
        }

        public A getProxy() {
            return this.proxy;
        }
    }
}

