/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.directory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import org.dbrain.binder.directory.Qualifiers;
import org.dbrain.binder.directory.ServiceKey;
import org.dbrain.binder.system.directory.QualifiersImpl;

public class ServiceKeyImpl<T>
implements ServiceKey<T> {
    private final Type serviceType;
    private final Class<T> serviceClass;
    private final Qualifiers qualifiers;

    public ServiceKeyImpl(Type serviceType, Class<T> serviceClass, Collection<Annotation> qualifiers) {
        this.serviceType = serviceType;
        this.serviceClass = serviceClass;
        this.qualifiers = new QualifiersImpl(qualifiers);
    }

    @Override
    public Type getServiceType() {
        return this.serviceType;
    }

    @Override
    public Class<T> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public Qualifiers getQualifiers() {
        return this.qualifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ServiceKey)) {
            return false;
        }
        ServiceKey that = (ServiceKey)o;
        if (!this.qualifiers.equals(that.getQualifiers())) {
            return false;
        }
        return this.serviceType.equals(that.getServiceType());
    }

    public int hashCode() {
        int result = this.serviceType.hashCode();
        result = 31 * result + this.qualifiers.hashCode();
        return result;
    }
}

