/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.http.server;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.dbrain.binder.system.lifecycle.ContextRegistry;
import org.dbrain.binder.system.scope.RequestScopeContext;
import org.dbrain.binder.system.scope.SessionScopeContext;

public class StandardScopeFilter
implements Filter {
    private final RequestScopeContext requestScopeContext;
    private final SessionScopeContext sessionScopeContext;

    @Inject
    public StandardScopeFilter(RequestScopeContext requestScopeContext, SessionScopeContext sessionScopeContext) {
        this.requestScopeContext = requestScopeContext;
        this.sessionScopeContext = sessionScopeContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        System.out.print("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.requestScopeContext.enter();
        this.sessionScopeContext.enter((Provider<ContextRegistry>)((Provider)() -> {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            HttpSession session = httpRequest.getSession(true);
            if (session != null) {
                ContextRegistry registry = (ContextRegistry)session.getAttribute(ContextRegistry.class.getName());
                if (registry == null) {
                    registry = new ContextRegistry();
                    session.setAttribute(ContextRegistry.class.getName(), (Object)registry);
                }
                return registry;
            }
            return null;
        }));
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            this.requestScopeContext.leave();
            this.sessionScopeContext.leave();
        }
    }

    public void destroy() {
    }
}

