/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.http.server.utils;

import java.net.URI;

public class ResourceSandbox {
    private final URI rootUri;

    public ResourceSandbox(URI rootUri) {
        if (rootUri == null || !rootUri.isAbsolute() || rootUri.isOpaque()) {
            throw new IllegalArgumentException();
        }
        this.rootUri = rootUri;
    }

    public URI getResource(URI trailingUri) {
        if (trailingUri == null || trailingUri.isAbsolute() || trailingUri.isOpaque()) {
            throw new IllegalArgumentException();
        }
        URI resourceUri = this.rootUri.resolve(trailingUri).normalize();
        URI relativeUri = this.rootUri.relativize(resourceUri);
        if (relativeUri.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return resourceUri;
    }

    public URI getResource(String trailingUri) {
        return this.getResource(URI.create(trailingUri));
    }
}

