/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.dbrain.binder.directory.ServiceKey;
import org.dbrain.binder.http.conf.WebSocketConfiguredServerConf;
import org.dbrain.binder.http.conf.WebSocketServiceServerConf;

public class WebSocketServerBuilder {
    private Class<?> endpointClass;
    private String path;
    private List<String> subprotocols = Collections.emptyList();
    private List<Extension> extensions = Collections.emptyList();
    private List<Class<? extends Encoder>> encoders = Collections.emptyList();
    private List<Class<? extends Decoder>> decoders = Collections.emptyList();

    public static WebSocketServiceServerConf of(Class<?> endpointClass) {
        return new WebSocketServiceServerConf(ServiceKey.of(endpointClass));
    }

    public static WebSocketServiceServerConf of(ServiceKey<?> endpointService) {
        return new WebSocketServiceServerConf(endpointService);
    }

    public static WebSocketConfiguredServerConf of(ServerEndpointConfig endpointConfig) {
        return new WebSocketConfiguredServerConf(endpointConfig);
    }

    public static WebSocketServerBuilder from(Class<?> endpointClass, String path) {
        return new WebSocketServerBuilder().endpointClass(endpointClass).path(path);
    }

    private WebSocketServerBuilder() {
    }

    public WebSocketServerBuilder path(String path) {
        this.path = path;
        return this;
    }

    public WebSocketServerBuilder endpointClass(Class<?> endpointClass) {
        this.endpointClass = endpointClass;
        return this;
    }

    public WebSocketServerBuilder subprotocols(String ... subprotocols) {
        this.subprotocols.clear();
        for (String subprotocol : subprotocols) {
            this.subprotocols.add(subprotocol);
        }
        return this;
    }

    public WebSocketServerBuilder addExtension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    public WebSocketServerBuilder addEncoder(Class<? extends Encoder> encoder) {
        this.encoders.add(encoder);
        return this;
    }

    public WebSocketServerBuilder addDecoder(Class<? extends Decoder> decoder) {
        this.decoders.add(decoder);
        return this;
    }

    public WebSocketConfiguredServerConf build() {
        return WebSocketServerBuilder.of(ServerEndpointConfig.Builder.create(this.endpointClass, (String)this.path).subprotocols(new ArrayList<String>(this.subprotocols)).extensions(new ArrayList<Extension>(this.extensions)).encoders(new ArrayList<Class<? extends Encoder>>(this.encoders)).decoders(new ArrayList<Class<? extends Decoder>>(this.decoders)).build());
    }
}

