/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.http.conf;

import javax.servlet.Filter;

public interface ServletFilterConf {
    public static ServletFilterConf of(String pathSpec, Filter instance) {
        return new ServletFilterInstanceDef(pathSpec, instance);
    }

    public static ServletFilterConf of(String pathSpec, Class<? extends Filter> filterClass) {
        return new ServletFilterClassDef(pathSpec, filterClass);
    }

    public void accept(Visitor var1);

    public static class ServletFilterInstanceDef
    implements ServletFilterConf {
        private final String pathSpec;
        private final Filter instance;

        public ServletFilterInstanceDef(String pathSpec, Filter instance) {
            this.instance = instance;
            this.pathSpec = pathSpec;
        }

        public String getPathSpec() {
            return this.pathSpec;
        }

        public Filter getInstance() {
            return this.instance;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static class ServletFilterClassDef
    implements ServletFilterConf {
        private final String pathSpec;
        private final Class<? extends Filter> filterClass;

        public ServletFilterClassDef(String pathSpec, Class<? extends Filter> filterClass) {
            this.pathSpec = pathSpec;
            this.filterClass = filterClass;
        }

        public String getPathSpec() {
            return this.pathSpec;
        }

        public Class<? extends Filter> getFilterClass() {
            return this.filterClass;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }
    }

    public static interface Visitor {
        public void visit(ServletFilterInstanceDef var1);

        public void visit(ServletFilterClassDef var1);
    }
}

