/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.binder.system.directory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.dbrain.binder.directory.ServiceKey;
import org.dbrain.binder.system.directory.ServiceKeyImpl;
import org.dbrain.binder.system.util.AnnotationBuilder;

public class ServiceKeyBuilderImpl<T>
implements ServiceKey.Builder<T> {
    private final Type serviceType;
    private final Class<T> serviceClass;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();

    public ServiceKeyBuilderImpl(Type serviceType, Class<T> serviceClass) {
        this.serviceType = serviceType;
        this.serviceClass = serviceClass;
    }

    @Override
    public ServiceKeyBuilderImpl<T> qualifiedBy(Annotation quality) {
        if (quality != null) {
            this.qualifiers.add(quality);
        }
        return this;
    }

    @Override
    public ServiceKeyBuilderImpl<T> qualifiedBy(Class<? extends Annotation> quality) {
        if (quality != null) {
            return this.qualifiedBy(AnnotationBuilder.of(quality));
        }
        return this;
    }

    @Override
    public ServiceKeyBuilderImpl<T> qualifiedBy(Iterable<Annotation> quality) {
        if (quality != null) {
            for (Annotation a : quality) {
                this.qualifiedBy(a);
            }
        }
        return this;
    }

    @Override
    public ServiceKeyBuilderImpl<T> named(String name) {
        if (name != null) {
            return this.qualifiedBy((Annotation)AnnotationBuilder.of(Named.class, name));
        }
        return this;
    }

    @Override
    public ServiceKey<T> build() {
        return new ServiceKeyImpl<T>(this.serviceType, this.serviceClass, this.qualifiers);
    }
}

