/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.DataTruncationException;
import org.dbrain.data.text.ParseException;
import org.dbrain.data.util.Strings;

public class Casts {
    private static Pattern NUMBER_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");

    public static BigDecimal toBigDecimal(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return new BigDecimal(o.trim());
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
            return new BigDecimal(((Number)o).longValue());
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof CharSequence) {
            return Casts.toBigDecimal(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to BigDecimal.");
    }

    public static BigInteger toBigInteger(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return new BigInteger(o.trim());
    }

    public static BigInteger toBigInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
            return new BigInteger(o.toString());
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue()).toBigIntegerExact();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toBigIntegerExact();
        }
        if (o instanceof CharSequence) {
            return Casts.toBigInteger(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to BigInteger.");
    }

    public static Double toDouble(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Double.parseDouble(o.trim());
    }

    public static Double toDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof CharSequence) {
            return Casts.toDouble(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Double.");
    }

    public static Float toFloat(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(o.trim()));
    }

    public static Float toFloat(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof CharSequence) {
            return Casts.toFloat(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Float.");
    }

    public static Long toLong(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.longValueExact();
    }

    public static Long toLong(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Casts.toLong(new BigDecimal(o.trim()));
    }

    public static Long toLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof AtomicInteger || o instanceof AtomicLong) {
            return ((Number)o).longValue();
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue()).longValueExact();
        }
        if (o instanceof BigDecimal) {
            return Casts.toLong((BigDecimal)o);
        }
        if (o instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)o;
            return bigInteger.longValueExact();
        }
        if (o instanceof CharSequence) {
            return Casts.toLong(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Long.");
    }

    public static Integer toInteger(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.intValueExact();
    }

    public static Integer toInteger(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Casts.toInteger(new BigDecimal(o.trim()));
    }

    public static Integer toInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof AtomicInteger) {
            return ((Number)o).intValue();
        }
        if (o instanceof Long || o instanceof AtomicLong) {
            long longValue = ((Number)o).longValue();
            if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                return (int)longValue;
            }
            throw new DataTruncationException();
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue()).intValueExact();
        }
        if (o instanceof BigDecimal) {
            return Casts.toInteger((BigDecimal)o);
        }
        if (o instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)o;
            return bigInteger.intValueExact();
        }
        if (o instanceof CharSequence) {
            return Casts.toInteger(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Integer.");
    }

    public static Short toShort(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.shortValueExact();
    }

    public static Short toShort(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Casts.toShort(new BigDecimal(o.trim()));
    }

    public static Short toShort(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Byte) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
            long longValue = ((Number)o).longValue();
            if (longValue >= -32768L && longValue <= 32767L) {
                return (short)longValue;
            }
            throw new DataTruncationException();
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue()).shortValueExact();
        }
        if (o instanceof BigDecimal) {
            return Casts.toShort((BigDecimal)o);
        }
        if (o instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)o;
            return bigInteger.shortValueExact();
        }
        if (o instanceof CharSequence) {
            return Casts.toShort(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Short.");
    }

    public static Byte toByte(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.byteValueExact();
    }

    public static Byte toByte(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        return Casts.toByte(new BigDecimal(o.trim()));
    }

    public static Byte toByte(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
            long longValue = ((Number)o).longValue();
            if (longValue >= -128L && longValue <= 127L) {
                return (byte)longValue;
            }
            throw new DataTruncationException();
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(((Number)o).doubleValue()).byteValueExact();
        }
        if (o instanceof BigDecimal) {
            return Casts.toByte((BigDecimal)o);
        }
        if (o instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)o;
            return bigInteger.byteValueExact();
        }
        if (o instanceof CharSequence) {
            return Casts.toByte(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Byte.");
    }

    public static String toString(Object o) {
        return o != null ? o.toString() : null;
    }

    public static String toEnumName(Enum e) {
        return e != null ? e.name() : null;
    }

    public static <T extends Enum<T>> T toEnum(Class<T> enumClass, String name) {
        return Strings.isBlank(name) ? null : (T)Enum.valueOf(enumClass, name.trim());
    }

    public static Boolean toBoolean(String o) {
        if (Strings.isBlank(o)) {
            return null;
        }
        if (NUMBER_PATTERN.matcher(o = o.trim()).matches()) {
            return Casts.toBigDecimal(o).compareTo(BigDecimal.ZERO) != 0;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(o)) {
            return true;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(o)) {
            return false;
        }
        throw new DataCoercionException("Cannot cast '" + o + "' to boolean.");
    }

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof AtomicInteger || o instanceof AtomicLong) {
            return ((Number)o).longValue() != 0L;
        }
        if (o instanceof Float || o instanceof Double) {
            return ((Number)o).doubleValue() != 0.0;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).compareTo(BigDecimal.ZERO) != 0;
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).compareTo(BigInteger.ZERO) != 0;
        }
        if (o instanceof CharSequence) {
            return Casts.toBoolean(o.toString());
        }
        throw new DataCoercionException("Cannot cast " + o + " to Boolean.");
    }

    public static LocalDate toLocalDate(java.util.Date date, ZoneId zoneId) {
        if (date != null) {
            if (date instanceof Date) {
                return ((Date)date).toLocalDate();
            }
            if (date instanceof Time) {
                throw new DataCoercionException("Cannot case " + date + " to LocalDate.");
            }
            return date.toInstant().atZone(zoneId).toLocalDate();
        }
        return null;
    }

    public static LocalDate toLocalDate(java.util.Date date) {
        return Casts.toLocalDate(date, ZoneId.systemDefault());
    }

    public static java.util.Date toDate(DateFormat format, String value) {
        if (!Strings.isBlank(value)) {
            try {
                return format.parse(value.trim());
            }
            catch (java.text.ParseException e) {
                throw new ParseException(e);
            }
        }
        return null;
    }

    public static Date toSqlDate(DateFormat format, String value) {
        return Casts.toSqlDate(Casts.toDate(format, value));
    }

    public static Date toSqlDate(java.util.Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    public static Date toSqlDate(LocalDate date) {
        return date != null ? Date.valueOf(date) : null;
    }

    public static Time toSqlTime(java.util.Date date) {
        return date != null ? new Time(date.getTime()) : null;
    }

    public static Time toSqlTime(DateFormat format, String time) {
        return Casts.toSqlTime(Casts.toDate(format, time));
    }

    public static Timestamp toSqlTimestamp(java.util.Date date) {
        return date != null ? new Timestamp(date.getTime()) : null;
    }
}

