/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TypeRegistry {
    private final Class<?> baseClass;
    private final Map<String, Class<?>> classMap;
    private final Map<Class<?>, String> nameMap;

    public static Builder newInstance(Function<Class<?>, String> nameFunc) {
        return new Builder(Object.class, nameFunc);
    }

    public static Builder newInstance(Class<?> baseClass, Function<Class<?>, String> nameFunc) {
        return new Builder(baseClass, nameFunc);
    }

    private TypeRegistry(Class<?> baseClass, Map<String, Class<?>> classMap, Map<Class<?>, String> nameMap) {
        this.baseClass = baseClass;
        this.classMap = classMap;
        this.nameMap = nameMap;
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public Class<?> getClass(String name) {
        return this.classMap.get(name);
    }

    public String getName(Class<?> clazz) {
        return this.nameMap.get(clazz);
    }

    public static class Builder {
        private final Class<?> baseClass;
        private final Function<Class<?>, String> getClassNameFunc;
        private final Map<String, Class<?>> classMap = new HashMap();
        private final Map<Class<?>, String> nameMap = new HashMap();

        public Builder(Class<?> baseClass, Function<Class<?>, String> getClassNameFunc) {
            Objects.requireNonNull(baseClass);
            Objects.requireNonNull(getClassNameFunc);
            this.baseClass = baseClass;
            this.getClassNameFunc = getClassNameFunc;
        }

        public Builder registerType(Class<?> clazz) {
            Objects.requireNonNull(clazz);
            if (!this.baseClass.isAssignableFrom(clazz)) {
                throw new IllegalStateException(clazz.getName() + " not a subclass of " + this.baseClass.getName());
            }
            if (!this.classMap.containsValue(clazz)) {
                String name = this.getClassNameFunc.apply(clazz);
                if (this.classMap.containsKey(name)) {
                    throw new IllegalStateException("Duplicate name " + name + " for class " + this.classMap.get(name).getName() + " and class " + clazz.getName());
                }
                this.classMap.put(name, clazz);
                this.nameMap.put(clazz, name);
            }
            return this;
        }

        public TypeRegistry build() {
            return new TypeRegistry(this.baseClass, this.classMap, this.nameMap);
        }
    }
}

