/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.dbrain.data.Value;
import org.dbrain.data.access.IndexedFieldAccessors;
import org.dbrain.data.impl.value.ListValueImpl;
import org.dbrain.data.impl.value.ValueListBuilderImpl;

public interface ValueList
extends Value,
List<Value>,
IndexedFieldAccessors {
    public static ValueList newInstance() {
        return new ListValueImpl();
    }

    public static Builder newBuilder() {
        return new ValueListBuilderImpl();
    }

    public static <T> ValueList asList(Object ... list) {
        return ValueList.of(list);
    }

    public static <T> ValueList of(T[] list) {
        if (list != null) {
            ValueList result = ValueList.newInstance();
            for (T o : list) {
                result.add(Value.of(o));
            }
            return result;
        }
        return null;
    }

    public static ValueList of(Iterable<Object> list) {
        if (list != null) {
            ValueList result = ValueList.newInstance();
            for (Object o : list) {
                result.add(Value.of(o));
            }
            return result;
        }
        return null;
    }

    public static interface Builder {
        public Builder addNull();

        public Builder add(Byte var1);

        public Builder add(Short var1);

        public Builder add(Integer var1);

        public Builder add(Long var1);

        public Builder add(BigInteger var1);

        public Builder add(BigDecimal var1);

        public Builder add(Float var1);

        public Builder add(Double var1);

        public Builder add(String var1);

        public Builder add(Boolean var1);

        public Builder add(Value var1);

        public ValueList build();
    }
}

