/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Function;
import org.dbrain.data.DataCoercionException;
import org.dbrain.data.Value;
import org.dbrain.data.access.NamedFieldAccessors;
import org.dbrain.data.impl.value.MapValueImpl;
import org.dbrain.data.impl.value.ValueMapBuilderImpl;

public interface ValueMap
extends Value,
Map<String, Value>,
NamedFieldAccessors {
    public static ValueMap newInstance() {
        return new MapValueImpl();
    }

    public static ValueMap of(Map<String, ?> v) {
        ValueMap result = ValueMap.newInstance();
        for (Map.Entry<String, ?> e : v.entrySet()) {
            result.put(e.getKey(), Value.of(e.getValue()));
        }
        return result;
    }

    public static ValueMap of(Map<?, ?> v, Function<Object, String> keyMapper) {
        ValueMap result = ValueMap.newInstance();
        for (Map.Entry<?, ?> e : v.entrySet()) {
            String key = keyMapper.apply(e.getKey());
            Value oldValue = result.put(key, Value.of(e.getValue()));
            if (oldValue == null) continue;
            throw new DataCoercionException("Duplicate value when casting to map: " + key);
        }
        return result;
    }

    public static Builder newBuilder() {
        return new ValueMapBuilderImpl();
    }

    public static interface Builder {
        public Builder putNull(String var1);

        public Builder put(String var1, Byte var2);

        public Builder put(String var1, Short var2);

        public Builder put(String var1, Integer var2);

        public Builder put(String var1, Long var2);

        public Builder put(String var1, BigInteger var2);

        public Builder put(String var1, BigDecimal var2);

        public Builder put(String var1, Float var2);

        public Builder put(String var1, Double var2);

        public Builder put(String var1, String var2);

        public Builder put(String var1, Boolean var2);

        public Builder put(String var1, Value var2);

        public ValueMap build();
    }
}

