/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import org.dbrain.data.FqnPattern;
import org.dbrain.data.impl.fqn.FqnPatternBuilderImpl;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public class FqnPatternParseUtils {
    public static FqnPattern parseFqnPattern(ReaderCursor c) {
        ParserUtils.skipWhitespaces(c);
        if (c.is("'*") || c.is(Character::isJavaIdentifierStart)) {
            FqnPatternBuilderImpl builder = new FqnPatternBuilderImpl();
            FqnPatternParseUtils.readPatternSegment(c, builder);
            while (c.is(".")) {
                c.read();
                FqnPatternParseUtils.readPatternSegment(c, builder);
            }
            return builder.build();
        }
        return new FqnPatternBuilderImpl().build();
    }

    private static void readWildcardSegment(ReaderCursor c, FqnPattern.Builder to) {
        c.skip("*");
        if (c.is("*")) {
            to.any();
            c.next();
        } else {
            to.one();
        }
    }

    private static void readPatternSegment(ReaderCursor c, FqnPattern.Builder to) {
        if (c.is("'")) {
            to.segment(ParserUtils.readQuotedString(c));
        } else if (c.is("*")) {
            FqnPatternParseUtils.readWildcardSegment(c, to);
        } else if (c.is(Character::isJavaIdentifierStart)) {
            to.segment(ParserUtils.readJavaIdentifier(c));
        } else {
            throw c.error("Expected Fqn pattern segment");
        }
    }
}

