/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dbrain.data.Fqn;
import org.dbrain.data.Path;
import org.dbrain.data.impl.path.PathImpl;

public class PathBuilderImpl
implements Path.Builder {
    private List<Object> nodes;

    @Override
    public PathBuilderImpl attr(String attr) {
        Objects.requireNonNull(attr);
        if (this.nodes == null) {
            this.nodes = new ArrayList<Object>();
        }
        this.nodes.add(attr);
        return this;
    }

    @Override
    public PathBuilderImpl index(long index) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Object>();
        }
        this.nodes.add(index);
        return this;
    }

    private void appendNode(Path path, int i) {
        switch (path.nodeType(i)) {
            case INDEX: {
                this.index(path.index(i));
                break;
            }
            case ATTRIBUTE: {
                this.attr(path.attr(i));
            }
        }
    }

    @Override
    public Path.Builder append(Path path) {
        if (path != null) {
            for (int i = 0; i < path.size(); ++i) {
                this.appendNode(path, i);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Path.Builder append(Path path, int startIdx, int endIdx) {
        if (path != null) {
            if (startIdx < 0 || endIdx < 0 || startIdx >= path.size() || endIdx > path.size()) throw new IndexOutOfBoundsException();
            for (int i = startIdx; i < endIdx; ++i) {
                this.appendNode(path, i);
            }
            return this;
        } else {
            if (startIdx == 0 && (endIdx < 0 || endIdx > 1)) return this;
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public Path.Builder append(Fqn fqn) {
        if (fqn != null) {
            for (int i = 0; i < fqn.size(); ++i) {
                this.attr(fqn.segment(i));
            }
        }
        return this;
    }

    @Override
    public Path build() {
        if (this.nodes != null) {
            return new PathImpl(this.nodes);
        }
        return PathImpl.EMPTY_PATH;
    }
}

