/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import java.util.ArrayList;
import java.util.List;
import org.dbrain.data.Path;
import org.dbrain.data.impl.path.PathParseUtils;

public final class PathImpl
implements Path {
    public static final Path EMPTY_PATH = new PathImpl(null);
    private final List<Object> nodes;

    public PathImpl(List<Object> nodes) {
        this.nodes = nodes != null && nodes.size() > 0 ? new ArrayList<Object>(nodes) : null;
    }

    @Override
    public int size() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    @Override
    public Path.NodeType nodeType(int i) {
        if (this.nodes != null) {
            return this.nodes.get(i) instanceof String ? Path.NodeType.ATTRIBUTE : Path.NodeType.INDEX;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long index(int i) {
        if (this.nodes != null) {
            return ((Number)this.nodes.get(i)).longValue();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String attr(int i) {
        if (this.nodes != null) {
            return (String)this.nodes.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Path head(int toIndex) {
        if (toIndex == 0) {
            return new PathImpl(null);
        }
        if (this.nodes != null) {
            return new PathImpl(this.nodes.subList(0, toIndex));
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Path tail(int size) {
        return this.tailFrom(this.size() - size);
    }

    @Override
    public Path tailFrom(int fromIndex) {
        if (this.nodes != null) {
            if (fromIndex == this.nodes.size()) {
                return new PathImpl(null);
            }
            return new PathImpl(this.nodes.subList(fromIndex, this.nodes.size()));
        }
        if (fromIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new PathImpl(null);
    }

    @Override
    public boolean startsWith(Path other) {
        if (other == null || other == this) {
            return true;
        }
        int otherSize = other.size();
        if (this.size() < otherSize) {
            return false;
        }
        for (int i = 0; i < otherSize; ++i) {
            if (this.attr(i).equals(other.attr(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path append(Path toAppend) {
        if (toAppend == null || toAppend.size() == 0) {
            return this;
        }
        return Path.from(this).append(toAppend).build();
    }

    @Override
    public Path append(String toAppend) {
        if (toAppend == null) {
            return this;
        }
        return this.append(Path.of(toAppend));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path fqn = (Path)o;
        if (this.size() != fqn.size()) {
            return false;
        }
        block4: for (int i = 0; i < this.size(); ++i) {
            if (!this.nodeType(i).equals((Object)fqn.nodeType(i))) {
                return false;
            }
            switch (this.nodeType(i)) {
                case ATTRIBUTE: {
                    if (this.attr(i).equals(fqn.attr(i))) continue block4;
                    return false;
                }
                case INDEX: {
                    if (this.index(i) == fqn.index(i)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        return this.nodes != null ? this.nodes.hashCode() : 0;
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < size; ++i) {
            switch (this.nodeType(i)) {
                case ATTRIBUTE: {
                    sb.append(PathParseUtils.encodeAttribute(this.attr(i), i == 0));
                    continue block4;
                }
                case INDEX: {
                    sb.append("[");
                    sb.append(this.index(i));
                    sb.append("]");
                }
            }
        }
        return sb.toString();
    }
}

