/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import org.dbrain.data.PathPattern;
import org.dbrain.data.impl.path.PathPatternImpl;

public class PathPatternBuilderImpl
implements PathPattern.Builder {
    private int partCount = 0;
    private PathPatternImpl.Node root = null;
    private PathPatternImpl.Node tail = null;

    private void addNode(PathPatternImpl.Node node) {
        if (this.tail == null) {
            this.root = node;
            this.tail = node;
        } else {
            this.tail.setNext(node);
            this.tail = node;
        }
        if (node instanceof PathPatternImpl.PartMatchingNode) {
            ((PathPatternImpl.PartMatchingNode)((Object)node)).setPartIdx(this.partCount++);
        }
    }

    @Override
    public PathPattern.Builder attr(String attr) {
        this.addNode(new PathPatternImpl.SpecificAttribute(attr));
        return this;
    }

    @Override
    public PathPattern.Builder index(long index) {
        this.addNode(new PathPatternImpl.SpecificIndex(index));
        return this;
    }

    @Override
    public PathPattern.Builder one() {
        this.addNode(new PathPatternImpl.OneNode());
        return this;
    }

    @Override
    public PathPattern.Builder any() {
        this.addNode(new PathPatternImpl.ManyNode());
        return this;
    }

    @Override
    public PathPattern build() {
        try {
            PathPattern pathPattern = this.root != null ? new PathPatternImpl(this.root, this.partCount) : PathPatternImpl.EMPTY_PATTERN;
            return pathPattern;
        }
        finally {
            this.root = null;
            this.tail = null;
            this.partCount = 0;
        }
    }
}

