/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import java.io.StringReader;
import org.dbrain.data.PathPattern;
import org.dbrain.data.impl.path.PathParseUtils;
import org.dbrain.data.impl.path.PathPatternBuilderImpl;
import org.dbrain.data.impl.path.PathPatternImpl;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public class PathPatternParseUtils {
    private static void readWildcardNode(ReaderCursor c, PathPattern.Builder to) {
        c.skip("*");
        if (c.is("*")) {
            to.any();
            c.next();
        } else {
            to.one();
        }
    }

    private static void readPatternNode(ReaderCursor c, PathPattern.Builder to) {
        if (c.is(Character::isJavaIdentifierStart)) {
            to.attr(PathParseUtils.readAttribute(c));
        } else if (c.is("[")) {
            PathPatternParseUtils.readBracketContent(c, to);
        } else if (c.is("*")) {
            PathPatternParseUtils.readWildcardNode(c, to);
        } else {
            c.error("Expecting an attribute or an index");
        }
    }

    public static PathPattern parsePathPattern(ReaderCursor c) {
        ParserUtils.skipWhitespaces(c);
        if (c.is(Character::isJavaIdentifierStart) || c.is("[*")) {
            PathPatternBuilderImpl builder = new PathPatternBuilderImpl();
            PathPatternParseUtils.readPatternNode(c, builder);
            while (c.is("[.")) {
                if (c.is(".")) {
                    c.next();
                }
                PathPatternParseUtils.readPatternNode(c, builder);
            }
            return builder.build();
        }
        return new PathPatternBuilderImpl().build();
    }

    public static PathPattern parsePathPattern(String fqn) {
        if (fqn == null) {
            return PathPatternImpl.EMPTY_PATTERN;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        PathPattern result = PathPatternParseUtils.parsePathPattern(c);
        ParserUtils.skipWhitespaces(c);
        if (c.current() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    private static void readBracketContent(ReaderCursor c, PathPattern.Builder to) {
        c.skip("[");
        ParserUtils.skipWhitespaces(c);
        if (c.is(ParserUtils::isDigit)) {
            to.index(PathParseUtils.readLong(c));
        } else if (c.is("'")) {
            to.attr(ParserUtils.readQuotedString(c));
        } else {
            throw c.error("Expecting quoted string or numerical index");
        }
        ParserUtils.skipWhitespaces(c);
        c.skip("]");
    }
}

