/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.dbrain.data.TextSerializer;
import org.dbrain.data.jackson.JacksonSerializerBuilder;
import org.dbrain.data.jackson.modules.StandardModule;
import org.dbrain.data.text.ParseException;

public class JacksonSerializer
implements TextSerializer {
    private final ObjectMapper objectMapper;

    public static JacksonSerializerBuilder newBuilder() {
        JacksonSerializerBuilder builder = new JacksonSerializerBuilder();
        builder.withModule(new StandardModule());
        builder.configureObjectMapper(om -> om.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
        return builder;
    }

    public static JacksonSerializerBuilder newEmptyBuilder() {
        return new JacksonSerializerBuilder();
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private void checkEof(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token != null) {
            throw new ParseException("Unexpected json token: " + token.name());
        }
    }

    public <T> T read(JsonParser r, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(r, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public <T> T read(String from, Class<T> clazz) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(from);
            T value = this.read(parser, clazz);
            this.checkEof(parser);
            return value;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public <T> T read(Reader from, Class<T> clazz) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(from);
            T value = this.read(parser, clazz);
            this.checkEof(parser);
            return value;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void write(Writer to, Object o) {
        try {
            this.objectMapper.writeValue(to, o);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String writeToString(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> T convert(Object o, Class<T> clazz) {
        try {
            return (T)this.objectMapper.convertValue(o, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

