/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.dbrain.data.jackson.JacksonSerializer;

public class JacksonSerializerBuilder {
    private final List<Module> modules = new ArrayList<Module>();
    private final List<Consumer<ObjectMapper>> omConfigs = new ArrayList<Consumer<ObjectMapper>>();

    JacksonSerializerBuilder() {
    }

    public JacksonSerializerBuilder withModule(Module module) {
        if (module != null) {
            this.modules.add(module);
        }
        return this;
    }

    public JacksonSerializerBuilder withModules(Module ... modules) {
        if (modules != null) {
            for (Module m : modules) {
                this.withModule(m);
            }
        }
        return this;
    }

    public JacksonSerializerBuilder configureObjectMapper(Consumer<ObjectMapper> omConfig) {
        if (omConfig != null) {
            this.omConfigs.add(omConfig);
        }
        return this;
    }

    public JacksonSerializer build() {
        ObjectMapper om = new ObjectMapper();
        om.registerModules(this.modules);
        for (Consumer<ObjectMapper> omConfig : this.omConfigs) {
            omConfig.accept(om);
        }
        return new JacksonSerializer(om);
    }
}

