/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.text;

import org.dbrain.data.text.ReaderCursor;

public class ParserUtils {
    public static void skipWhitespaces(ReaderCursor c) {
        while (c.is(Character::isWhitespace)) {
            c.next();
        }
    }

    public static boolean isDigit(int cur) {
        return cur >= 48 && cur <= 57;
    }

    public static String readQuotedString(ReaderCursor c) {
        int quote = c.read();
        StringBuilder sb = new StringBuilder();
        while (true) {
            int current;
            if ((current = c.read()) == quote) {
                if (c.current() != quote) break;
                sb.appendCodePoint(c.read());
                continue;
            }
            if (current < 0) {
                throw c.error("Unexpected eof");
            }
            sb.appendCodePoint(current);
        }
        return sb.toString();
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.codePointAt(0))) {
            return false;
        }
        return s.substring(1).codePoints().allMatch(Character::isJavaIdentifierPart);
    }

    public static String readJavaIdentifier(ReaderCursor c) {
        if (c.is(Character::isJavaIdentifierStart)) {
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(c.read());
            int cur = c.current();
            while (Character.isJavaIdentifierPart(cur)) {
                sb.appendCodePoint(cur);
                cur = c.next();
            }
            return sb.toString();
        }
        return null;
    }
}

