/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.IntPredicate;
import org.dbrain.data.text.ParseException;

public class ReaderCursor
implements AutoCloseable {
    private static final String ERR_IO_ERROR = "IO exception";
    private static final String ERR_SURROGATE_ENCODING = "Surrogate encoding error";
    private Reader reader;
    private boolean loaded;
    private int current;
    private int index = 1;
    private int line = 1;
    private int column = 1;

    public ReaderCursor(Reader r) {
        this.reader = r;
    }

    public ReaderCursor(String s) {
        this(new StringReader(s));
    }

    private int readCodePoint() {
        try {
            int firstChar = this.reader.read();
            if (firstChar >= 0 && Character.isHighSurrogate((char)firstChar)) {
                int secondChar = this.reader.read();
                if (secondChar >= 0) {
                    if (Character.isSurrogatePair((char)firstChar, (char)secondChar)) {
                        return Character.toCodePoint((char)firstChar, (char)secondChar);
                    }
                    throw this.error(ERR_SURROGATE_ENCODING, null);
                }
                throw this.error(ERR_SURROGATE_ENCODING, null);
            }
            return firstChar;
        }
        catch (IOException ie) {
            throw this.error(ERR_IO_ERROR, ie);
        }
    }

    public ParseException error(String message, Throwable e) {
        return new ParseException(String.format("%s at %s.", message, this.position()), e);
    }

    public ParseException error(String message) {
        return this.error(message, null);
    }

    private String position() {
        return String.format("position %d [%d:%d]", this.index, this.line, this.column);
    }

    public int current() {
        if (!this.loaded) {
            this.current = this.readCodePoint();
            this.loaded = true;
        }
        return this.current;
    }

    private void flush() {
        if (this.current >= 0 && this.loaded) {
            if (this.current >= 0) {
                this.index += this.current <= 65535 ? 1 : 2;
                if (this.current == 10) {
                    ++this.line;
                    this.column = 1;
                } else if (this.current == 9) {
                    this.column += 4;
                } else if (this.current >= 32) {
                    ++this.column;
                }
            }
            this.loaded = false;
        }
    }

    public boolean is(IntPredicate predicate) {
        return predicate.test(this.current());
    }

    public boolean is(String chars) {
        int cur = this.current();
        return cur >= 0 && chars.indexOf(cur) >= 0;
    }

    public int next() {
        this.flush();
        return this.current();
    }

    public int read() {
        int result = this.current();
        this.flush();
        return result;
    }

    public String read(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(count);
        int c = this.read();
        for (int i = 0; i < count && c >= 0; ++i) {
            sb.appendCodePoint(c);
            c = this.read();
        }
        return sb.toString();
    }

    public void skip(String which) {
        if (!this.is(which)) {
            throw this.error("expecting " + which);
        }
        this.flush();
    }

    public boolean eof() {
        return this.current() < 0;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReaderCursor index=");
        sb.append(Integer.toString(this.index));
        sb.append(" char=[");
        int peeked = this.current();
        if (peeked >= 0) {
            sb.appendCodePoint(this.current());
        } else {
            sb.append("eof");
        }
        sb.append("]");
        return sb.toString();
    }
}

