/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import org.dbrain.data.Fqn;
import org.dbrain.data.impl.fqn.FqnParseUtils;
import org.dbrain.data.impl.fqn.FqnPatternBuilderImpl;

public interface FqnPattern {
    public static Builder newBuilder() {
        return new FqnPatternBuilderImpl();
    }

    public static FqnPattern of(String fqn) {
        return FqnParseUtils.parseFqnPattern(fqn);
    }

    public MatchResult match(Fqn var1);

    public Specs getSpecs();

    public static interface Builder {
        public Builder segment(String var1);

        public Builder one();

        public Builder any();

        public FqnPattern build();
    }

    public static interface Specs {
        public Type getType();

        public Fqn scope();
    }

    public static interface MatchResult {
        public boolean matched();

        public int partCount();

        public Fqn getPart(int var1);
    }

    public static enum Type {
        EXACT_MATCH,
        PARTIAL;

    }
}

