/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.util.Arrays;
import org.dbrain.data.Fqn;
import org.dbrain.data.impl.path.PathBuilderImpl;
import org.dbrain.data.impl.path.PathImpl;
import org.dbrain.data.impl.path.PathParseUtils;
import org.dbrain.data.text.ReaderCursor;

public interface Path {
    public static Path empty() {
        return PathImpl.EMPTY_PATH;
    }

    public static Path of(ReaderCursor c) {
        return PathParseUtils.parsePath(c);
    }

    public static Path of(String path) {
        return PathParseUtils.parsePath(path);
    }

    public static Path ofAttr(String attr) {
        if (attr != null) {
            return new PathImpl(Arrays.asList(attr));
        }
        return Path.of((String)null);
    }

    public static Builder fromAttr(String attr) {
        return Path.newBuilder().attr(attr);
    }

    public static Builder from(Path path) {
        return Path.newBuilder().append(path);
    }

    public static Builder from(Path path, int startIdx, int endIdx) {
        return Path.newBuilder().append(path, startIdx, endIdx);
    }

    public static Builder newBuilder() {
        return new PathBuilderImpl();
    }

    public int size();

    public NodeType nodeType(int var1);

    public String attr(int var1);

    public long index(int var1);

    public Path head(int var1);

    public Path tail(int var1);

    public Path tailFrom(int var1);

    public boolean startsWith(Path var1);

    public Path append(Path var1);

    public Path append(String var1);

    public static interface Builder {
        public Builder index(long var1);

        public Builder attr(String var1);

        public Builder append(Path var1);

        public Builder append(Path var1, int var2, int var3);

        public Builder append(Fqn var1);

        public Path build();
    }

    public static enum NodeType {
        ATTRIBUTE,
        INDEX;

    }
}

