/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class TypeRegistry<T> {
    private final Class<T> baseClass;
    private final Map<String, Class<? extends T>> classMap;
    private final Map<Class<? extends T>, String> nameMap;

    public static final Builder from(Class<?> baseClass, Function<Class<?>, String> nameFunc) {
        return new Builder(baseClass, nameFunc);
    }

    TypeRegistry(Class<T> baseClass, Map<String, Class<? extends T>> classMap, Map<Class<? extends T>, String> nameMap) {
        this.baseClass = baseClass;
        this.classMap = classMap;
        this.nameMap = nameMap;
    }

    public Class<T> getBaseClass() {
        return this.baseClass;
    }

    public Class<? extends T> getTypeByName(String name) {
        Objects.requireNonNull(name);
        return this.classMap.get(name);
    }

    public String getNameByType(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        return this.nameMap.get(clazz);
    }

    public static class Builder<T> {
        private final Class<T> baseClass;
        private final Function<Class<?>, String> nameFunc;
        private Map<String, Class<? extends T>> classById = new HashMap<String, Class<? extends T>>();
        private Map<Class<? extends T>, String> idByClass = new HashMap<Class<? extends T>, String>();

        Builder(Class<T> baseClass, Function<Class<?>, String> nameFunc) {
            this.baseClass = baseClass;
            this.nameFunc = nameFunc;
        }

        public Builder<T> registerType(Class<? extends T> clazz) {
            Objects.requireNonNull(clazz);
            if (!this.idByClass.containsKey(clazz)) {
                String name = this.nameFunc.apply(clazz);
                if (name == null) {
                    throw new IllegalStateException("Class does not provide any type information: " + clazz.getName());
                }
                if (this.classById.containsKey(name)) {
                    throw new IllegalStateException("Two classes has same name: " + this.classById.get(name).getName() + " and " + clazz.getName());
                }
                if (!this.baseClass.isAssignableFrom(clazz)) {
                    throw new IllegalStateException(clazz.getName() + " is not a subclass of the registry's base class: " + this.baseClass.getName());
                }
                this.idByClass.put(clazz, name);
                this.classById.put(name, clazz);
            }
            return this;
        }

        public TypeRegistry<T> build() {
            return new TypeRegistry<T>(this.baseClass, this.classById, this.idByClass);
        }
    }
}

