/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import java.util.ArrayList;
import java.util.List;
import org.dbrain.data.Fqn;
import org.dbrain.data.impl.fqn.FqnParseUtils;

public final class FqnImpl
implements Fqn {
    public static final Fqn EMPTY_NAME = new FqnImpl(null);
    private final List<String> segments;

    public FqnImpl(List<String> segments) {
        this.segments = segments != null && segments.size() > 0 ? new ArrayList<String>(segments) : null;
    }

    @Override
    public int size() {
        return this.segments != null ? this.segments.size() : 0;
    }

    @Override
    public String segment(int i) {
        if (this.segments != null) {
            return this.segments.get(i);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Fqn head(int toIndex) {
        if (toIndex == 0) {
            return new FqnImpl(null);
        }
        if (this.segments != null) {
            return new FqnImpl(this.segments.subList(0, toIndex));
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Fqn tail(int size) {
        return this.tailFrom(this.size() - size);
    }

    @Override
    public Fqn tailFrom(int fromIndex) {
        if (this.segments != null) {
            if (fromIndex == this.segments.size()) {
                return new FqnImpl(null);
            }
            return new FqnImpl(this.segments.subList(fromIndex, this.segments.size()));
        }
        if (fromIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new FqnImpl(null);
    }

    @Override
    public boolean startsWith(Fqn other) {
        if (other == null || other == this) {
            return true;
        }
        int otherSize = other.size();
        if (this.size() < otherSize) {
            return false;
        }
        for (int i = 0; i < otherSize; ++i) {
            if (this.segment(i).equals(other.segment(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fqn fqn = (Fqn)o;
        if (this.size() != fqn.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.segment(i).equals(fqn.segment(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.segments != null ? this.segments.hashCode() : 0;
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return FqnParseUtils.encodeSegment(this.segment(0));
        }
        StringBuilder sb = null;
        for (int i = 0; i < size; ++i) {
            String s = this.segment(i);
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(".");
            }
            sb.append(FqnParseUtils.encodeSegment(s));
        }
        return sb != null ? sb.toString() : "";
    }
}

