/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import java.io.StringReader;
import java.util.ArrayList;
import org.dbrain.data.Fqn;
import org.dbrain.data.FqnPattern;
import org.dbrain.data.impl.fqn.FqnImpl;
import org.dbrain.data.impl.fqn.FqnPatternImpl;
import org.dbrain.data.impl.fqn.FqnPatternParseUtils;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public final class FqnParseUtils {
    public static Fqn parseFqn(ReaderCursor c) {
        ParserUtils.skipWhitespaces(c);
        if (c.is(Character::isJavaIdentifierStart) || c.is("'")) {
            ArrayList<String> segments = new ArrayList<String>();
            segments.add(FqnParseUtils.readSegment(c));
            while (c.is(".")) {
                c.next();
                segments.add(FqnParseUtils.readSegment(c));
            }
            return new FqnImpl(segments);
        }
        return FqnImpl.EMPTY_NAME;
    }

    public static Fqn parseFqn(String fqn) {
        if (fqn == null) {
            return FqnImpl.EMPTY_NAME;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        Fqn result = FqnParseUtils.parseFqn(c);
        ParserUtils.skipWhitespaces(c);
        if (!c.eof()) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    public static FqnPattern parseFqnPattern(String fqn) {
        if (fqn == null) {
            return FqnPatternImpl.EMPTY_PATTERN;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(fqn));
        FqnPattern result = FqnPatternParseUtils.parseFqnPattern(c);
        ParserUtils.skipWhitespaces(c);
        if (!c.eof()) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    private static String readSegment(ReaderCursor c) {
        if (c.is("'")) {
            return ParserUtils.readQuotedString(c);
        }
        return ParserUtils.readJavaIdentifier(c);
    }

    public static String encodeSegment(String segment) {
        if (segment.length() == 0) {
            return "''";
        }
        if (ParserUtils.isJavaIdentifier(segment)) {
            return segment;
        }
        return "'" + segment.replaceAll("'", "''") + "'";
    }
}

