/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.fqn;

import org.dbrain.data.Fqn;
import org.dbrain.data.FqnPattern;
import org.dbrain.data.impl.fqn.FqnImpl;
import org.dbrain.data.impl.fqn.FqnParseUtils;

public class FqnPatternImpl
implements FqnPattern {
    public static final FqnPattern EMPTY_PATTERN = new FqnPatternImpl(null, 0);
    private Node root;
    private int partCount;
    private FqnPattern.Specs specs;

    public FqnPatternImpl(Node root, int partCount) {
        this.root = root;
        this.partCount = partCount;
    }

    @Override
    public FqnPattern.MatchResult match(Fqn fqn) {
        if (this.root == null) {
            if (fqn == null || fqn.size() == 0) {
                return new MatchResultImpl(true, this.partCount);
            }
            return new MatchResultImpl(false, this.partCount);
        }
        MatchResultImpl result = new MatchResultImpl(false, this.partCount);
        this.root.match(fqn, 0, result);
        return result;
    }

    @Override
    public FqnPattern.Specs getSpecs() {
        if (this.specs == null) {
            Node node;
            if (this.root == null) {
                this.specs = new SpecsImpl(FqnPattern.Type.EXACT_MATCH, FqnImpl.EMPTY_NAME);
            }
            Fqn.Builder scope = Fqn.newBuilder();
            for (node = this.root; node != null && node instanceof SpecificNode; node = node.getNext()) {
                scope.segment(((SpecificNode)node).getSegment());
            }
            this.specs = new SpecsImpl(node != null ? FqnPattern.Type.PARTIAL : FqnPattern.Type.EXACT_MATCH, scope.build());
        }
        return this.specs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Node node = this.root; node != null; node = node.getNext()) {
            sb.append(node.toString());
            if (node.getNext() == null) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public static class ManyNode
    extends Node
    implements PartMatchingNode {
        private int partIdx;

        @Override
        boolean match(Fqn fqn, int i, MatchResultImpl mr) {
            boolean result;
            int j;
            if (i > fqn.size()) {
                return mr.answer(false);
            }
            if (this.next != null) {
                for (j = fqn.size(); j >= i && !this.next.match(fqn, j, mr); --j) {
                }
            }
            boolean bl = result = j >= i;
            if (result) {
                Fqn.Builder part = Fqn.newBuilder();
                for (int x = i; x < j; ++x) {
                    part.segment(fqn.segment(x));
                }
                mr.setPart(this.partIdx, part.build());
            }
            return mr.answer(result);
        }

        @Override
        public void setPartIdx(int partIdx) {
            this.partIdx = partIdx;
        }

        public String toString() {
            return "**";
        }
    }

    public static class OneNode
    extends Node
    implements PartMatchingNode {
        int partIdx;

        @Override
        boolean match(Fqn fqn, int i, MatchResultImpl mr) {
            boolean result;
            if (i >= fqn.size()) {
                return mr.answer(false);
            }
            if (this.next != null) {
                result = this.next.match(fqn, i + 1, mr);
            } else {
                boolean bl = result = i == fqn.size() - 1;
            }
            if (result) {
                mr.setPart(this.partIdx, Fqn.fromSegment(fqn.segment(i)).build());
            }
            return mr.answer(result);
        }

        @Override
        public void setPartIdx(int partIdx) {
            this.partIdx = partIdx;
        }

        public String toString() {
            return "*";
        }
    }

    public static class SpecificNode
    extends Node {
        private String segment;

        public SpecificNode(String segment) {
            this.segment = segment;
        }

        public String getSegment() {
            return this.segment;
        }

        @Override
        boolean match(Fqn fqn, int i, MatchResultImpl mr) {
            if (i >= fqn.size() || !fqn.segment(i).equals(this.segment)) {
                return mr.answer(false);
            }
            boolean result = this.next != null ? this.next.match(fqn, i + 1, mr) : i == fqn.size() - 1;
            return mr.answer(result);
        }

        public String toString() {
            return FqnParseUtils.encodeSegment(this.segment);
        }
    }

    public static abstract class Node {
        protected Node next;

        abstract boolean match(Fqn var1, int var2, MatchResultImpl var3);

        Node getNext() {
            return this.next;
        }

        void setNext(Node next) {
            this.next = next;
        }
    }

    static class SpecsImpl
    implements FqnPattern.Specs {
        private final FqnPattern.Type type;
        private final Fqn scope;

        public SpecsImpl(FqnPattern.Type type, Fqn scope) {
            this.type = type;
            this.scope = scope;
        }

        @Override
        public FqnPattern.Type getType() {
            return this.type;
        }

        @Override
        public Fqn scope() {
            return this.scope;
        }
    }

    static class MatchResultImpl
    implements FqnPattern.MatchResult {
        private boolean matched;
        private int partCount;
        private Fqn[] parts;

        public MatchResultImpl(boolean matched, int partCount) {
            this.matched = matched;
            this.partCount = partCount;
        }

        @Override
        public boolean matched() {
            return this.matched;
        }

        @Override
        public int partCount() {
            return this.partCount;
        }

        @Override
        public Fqn getPart(int idx) {
            if (this.parts != null) {
                return this.parts[idx];
            }
            if (idx >= 0 && idx < this.partCount) {
                return null;
            }
            throw new IndexOutOfBoundsException();
        }

        boolean answer(boolean value) {
            this.matched = value;
            return value;
        }

        void setPart(int idx, Fqn part) {
            if (this.parts == null) {
                this.parts = new Fqn[this.partCount];
            }
            this.parts[idx] = part;
        }
    }

    public static interface PartMatchingNode {
        public void setPartIdx(int var1);
    }
}

