/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import java.io.StringReader;
import org.dbrain.data.Path;
import org.dbrain.data.impl.path.PathImpl;
import org.dbrain.data.text.ParserUtils;
import org.dbrain.data.text.ReaderCursor;

public final class PathParseUtils {
    public static Path parsePath(ReaderCursor c) {
        ParserUtils.skipWhitespaces(c);
        if (c.is(Character::isJavaIdentifierStart) || c.is("[")) {
            Path.Builder builder = Path.newBuilder();
            PathParseUtils.readPathNode(c, builder);
            while (true) {
                if (c.is("[")) {
                    PathParseUtils.readIndex(c, builder);
                    continue;
                }
                if (!c.is(".")) break;
                c.next();
                builder.attr(PathParseUtils.readAttribute(c));
            }
            return builder.build();
        }
        return PathImpl.EMPTY_PATH;
    }

    public static Path parsePath(String path) {
        if (path == null) {
            return PathImpl.EMPTY_PATH;
        }
        ReaderCursor c = new ReaderCursor(new StringReader(path));
        Path result = PathParseUtils.parsePath(c);
        ParserUtils.skipWhitespaces(c);
        if (c.current() >= 0) {
            throw c.error("Expecting end of string");
        }
        return result;
    }

    public static String readAttribute(ReaderCursor c) {
        StringBuilder sb = new StringBuilder();
        int cur = c.current();
        while (Character.isJavaIdentifierPart(cur)) {
            sb.appendCodePoint(cur);
            cur = c.next();
        }
        return sb.toString();
    }

    public static long readLong(ReaderCursor c) {
        long index = 0L;
        int cur = c.current();
        while (ParserUtils.isDigit(cur)) {
            index = index * 10L + (long)cur - 48L;
            cur = c.next();
        }
        return index;
    }

    private static void readIndex(ReaderCursor c, Path.Builder to) {
        c.next();
        ParserUtils.skipWhitespaces(c);
        if (c.is(ParserUtils::isDigit)) {
            to.index(PathParseUtils.readLong(c));
        } else if (c.is("'")) {
            to.attr(ParserUtils.readQuotedString(c));
        } else {
            throw c.error("Expecting quoted string or numerical index");
        }
        ParserUtils.skipWhitespaces(c);
        if (!c.is("]")) {
            throw c.error("Expecting ]");
        }
        c.next();
    }

    private static void readPathNode(ReaderCursor c, Path.Builder to) {
        if (c.is("[")) {
            PathParseUtils.readIndex(c, to);
        } else if (c.is(Character::isJavaIdentifierStart)) {
            to.attr(PathParseUtils.readAttribute(c));
        } else {
            throw c.error("Expected attribute or [");
        }
    }

    static String encodeAttribute(String attr, boolean first) {
        if (attr.length() == 0) {
            return "['']";
        }
        if (ParserUtils.isJavaIdentifier(attr)) {
            return first ? attr : "." + attr;
        }
        return "['" + attr.replaceAll("'", "''") + "']";
    }
}

