/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.impl.path;

import org.dbrain.data.Path;
import org.dbrain.data.PathPattern;
import org.dbrain.data.impl.path.PathParseUtils;

public class PathPatternImpl
implements PathPattern {
    public static final PathPattern EMPTY_PATTERN = new PathPatternImpl(null, 0);
    private Node root;
    private int partCount;
    private PathPattern.Specs specs;

    public PathPatternImpl(Node root, int partCount) {
        this.root = root;
        this.partCount = partCount;
    }

    @Override
    public PathPattern.MatchResult match(Path path) {
        if (this.root == null) {
            if (path == null || path.size() == 0) {
                return new MatchResultImpl(true, this.partCount);
            }
            return new MatchResultImpl(false, this.partCount);
        }
        MatchResultImpl result = new MatchResultImpl(false, this.partCount);
        this.root.match(path, 0, result);
        return result;
    }

    @Override
    public PathPattern.Specs getSpecs() {
        if (this.specs == null) {
            Node node;
            if (this.root == null) {
                this.specs = new SpecsImpl(PathPattern.Type.EXACT_MATCH, Path.empty());
            }
            Path.Builder scope = Path.newBuilder();
            for (node = this.root; node != null; node = node.getNext()) {
                if (node instanceof SpecificAttribute) {
                    scope.attr(((SpecificAttribute)node).getAttr());
                    continue;
                }
                if (!(node instanceof SpecificIndex)) break;
                scope.index(((SpecificIndex)node).getIndex());
            }
            this.specs = new SpecsImpl(node != null ? PathPattern.Type.PARTIAL : PathPattern.Type.EXACT_MATCH, scope.build());
        }
        return this.specs;
    }

    public String toString() {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (Node node = this.root; node != null; node = node.getNext()) {
            sb.append(node.toString(i++));
        }
        return sb.toString();
    }

    public static class ManyNode
    extends Node
    implements PartMatchingNode {
        private int partIdx;

        @Override
        boolean match(Path path, int i, MatchResultImpl mr) {
            boolean result;
            int j;
            if (i > path.size()) {
                return mr.answer(false);
            }
            if (this.next != null) {
                for (j = path.size(); j >= i && !this.next.match(path, j, mr); --j) {
                }
            }
            boolean bl = result = j >= i;
            if (result) {
                Path.Builder part = Path.newBuilder();
                for (int x = i; x < j; ++x) {
                    part.append(path, x, x + 1);
                }
                mr.setPart(this.partIdx, part.build());
            }
            return mr.answer(result);
        }

        @Override
        public void setPartIdx(int partIdx) {
            this.partIdx = partIdx;
        }

        @Override
        public String toString(int pos) {
            return pos == 0 ? "**" : ".**";
        }
    }

    public static class OneNode
    extends Node
    implements PartMatchingNode {
        int partIdx;

        @Override
        boolean match(Path path, int i, MatchResultImpl mr) {
            boolean result;
            if (i >= path.size()) {
                return mr.answer(false);
            }
            if (this.next != null) {
                result = this.next.match(path, i + 1, mr);
            } else {
                boolean bl = result = i == path.size() - 1;
            }
            if (result) {
                mr.setPart(this.partIdx, Path.from(path, i, i + 1).build());
            }
            return mr.answer(result);
        }

        @Override
        public void setPartIdx(int partIdx) {
            this.partIdx = partIdx;
        }

        @Override
        public String toString(int pos) {
            return pos == 0 ? "*" : ".*";
        }
    }

    public static class SpecificIndex
    extends Node {
        private long index;

        public SpecificIndex(long index) {
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }

        @Override
        boolean match(Path path, int i, MatchResultImpl mr) {
            if (i >= path.size() || path.nodeType(i) != Path.NodeType.INDEX || path.index(i) != this.index) {
                return mr.answer(false);
            }
            boolean result = this.next != null ? this.next.match(path, i + 1, mr) : i == path.size() - 1;
            return mr.answer(result);
        }

        @Override
        public String toString(int pos) {
            return "[" + this.index + "]";
        }
    }

    public static class SpecificAttribute
    extends Node {
        private String attr;

        public SpecificAttribute(String attr) {
            this.attr = attr;
        }

        public String getAttr() {
            return this.attr;
        }

        @Override
        boolean match(Path path, int i, MatchResultImpl mr) {
            if (i >= path.size() || path.nodeType(i) != Path.NodeType.ATTRIBUTE || !path.attr(i).equals(this.attr)) {
                return mr.answer(false);
            }
            boolean result = this.next != null ? this.next.match(path, i + 1, mr) : i == path.size() - 1;
            return mr.answer(result);
        }

        @Override
        protected String toString(int pos) {
            return PathParseUtils.encodeAttribute(this.attr, pos == 0);
        }
    }

    public static abstract class Node {
        protected Node next;

        abstract boolean match(Path var1, int var2, MatchResultImpl var3);

        Node getNext() {
            return this.next;
        }

        void setNext(Node next) {
            this.next = next;
        }

        abstract String toString(int var1);

        public String toString() {
            return this.toString(0);
        }
    }

    static class SpecsImpl
    implements PathPattern.Specs {
        private final PathPattern.Type type;
        private final Path scope;

        public SpecsImpl(PathPattern.Type type, Path scope) {
            this.type = type;
            this.scope = scope;
        }

        @Override
        public PathPattern.Type getType() {
            return this.type;
        }

        @Override
        public Path scope() {
            return this.scope;
        }
    }

    static class MatchResultImpl
    implements PathPattern.MatchResult {
        private boolean matched;
        private int partCount;
        private Path[] parts;

        public MatchResultImpl(boolean matched, int partCount) {
            this.matched = matched;
            this.partCount = partCount;
        }

        @Override
        public boolean matched() {
            return this.matched;
        }

        @Override
        public int partCount() {
            return this.partCount;
        }

        @Override
        public Path getPart(int idx) {
            if (this.parts != null) {
                return this.parts[idx];
            }
            if (idx >= 0 && idx < this.partCount) {
                return null;
            }
            throw new IndexOutOfBoundsException();
        }

        boolean answer(boolean value) {
            this.matched = value;
            return value;
        }

        void setPart(int idx, Path part) {
            if (this.parts == null) {
                this.parts = new Path[this.partCount];
            }
            this.parts[idx] = part;
        }
    }

    public static interface PartMatchingNode {
        public void setPartIdx(int var1);
    }
}

