/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.dbrain.data.ObjectConverter;
import org.dbrain.data.TextSerializer;
import org.dbrain.data.jackson.modules.StandardModule;
import org.dbrain.data.text.ParseException;

public class JacksonSerializer
implements TextSerializer,
ObjectConverter {
    private final ObjectMapper objectMapper;

    public static Builder newBuilder() {
        Builder builder = new Builder();
        builder.withModule(new StandardModule());
        builder.withConfigurator(om -> om.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true));
        return builder;
    }

    public static Builder newEmptyBuilder() {
        return new Builder();
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private void checkEof(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        if (token != null) {
            throw new ParseException("Unexpected json token: " + token.name());
        }
    }

    public <T> T read(JsonParser r, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(r, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public <T> T read(String from, Class<T> clazz) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(from);
            T value = this.read(parser, clazz);
            this.checkEof(parser);
            return value;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public <T> T read(Reader from, Class<T> clazz) {
        try {
            JsonParser parser = this.objectMapper.getFactory().createParser(from);
            T value = this.read(parser, clazz);
            this.checkEof(parser);
            return value;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void write(Writer to, Object o) {
        try {
            this.objectMapper.writeValue(to, o);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String writeToString(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> T convert(Object o, Class<T> clazz) {
        try {
            return (T)this.objectMapper.convertValue(o, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static class Builder {
        private final List<Module> modules = new ArrayList<Module>();
        private final List<Consumer<ObjectMapper>> omConfigs = new ArrayList<Consumer<ObjectMapper>>();
        private TypeResolverBuilder<?> typing;

        Builder() {
        }

        public Builder withModule(Module module) {
            if (module != null) {
                this.modules.add(module);
            }
            return this;
        }

        public Builder withModules(Module ... modules) {
            if (modules != null) {
                for (Module m : modules) {
                    this.withModule(m);
                }
            }
            return this;
        }

        public Builder withConfigurator(Consumer<ObjectMapper> configurator) {
            if (configurator != null) {
                this.omConfigs.add(configurator);
            }
            return this;
        }

        public Builder withTyping(TypeResolverBuilder<?> typing) {
            this.typing = typing;
            return this;
        }

        public JacksonSerializer build() {
            ObjectMapper om = new ObjectMapper();
            om.registerModules(this.modules);
            if (this.typing != null) {
                om.setDefaultTyping(this.typing);
            }
            for (Consumer<ObjectMapper> omConfig : this.omConfigs) {
                omConfig.accept(om);
            }
            return new JacksonSerializer(om);
        }
    }
}

