/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.dbrain.data.Value;
import org.dbrain.data.ValueList;
import org.dbrain.data.ValueMap;
import org.dbrain.data.impl.value.NullValueImpl;

public class JacksonSerializationUtils {
    public static JsonToken getToken(JsonParser parser) throws IOException {
        return parser.hasCurrentToken() ? parser.getCurrentToken() : parser.nextToken();
    }

    public static Value parseValue(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonToken token = JacksonSerializationUtils.getToken(parser);
        if (token != null) {
            Value result;
            switch (token) {
                case VALUE_STRING: {
                    result = Value.of(parser.getValueAsString());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = Value.of(parser.getDoubleValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = Value.of(parser.getBigIntegerValue());
                    break;
                }
                case VALUE_NULL: {
                    result = NullValueImpl.NULL;
                    break;
                }
                case VALUE_TRUE: {
                    result = Value.of(Boolean.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    result = Value.of(Boolean.FALSE);
                    break;
                }
                case START_OBJECT: {
                    ValueMap values = ValueMap.newInstance();
                    while (parser.nextToken() == JsonToken.FIELD_NAME) {
                        String key = parser.getCurrentName();
                        parser.nextToken();
                        Value v = JacksonSerializationUtils.parseValue(parser, ctxt);
                        if (v == null) {
                            throw ctxt.wrongTokenException(parser, JsonToken.START_OBJECT, "Expected Value");
                        }
                        values.put(key, v);
                    }
                    if (JacksonSerializationUtils.getToken(parser) != JsonToken.END_OBJECT) {
                        throw ctxt.wrongTokenException(parser, JsonToken.END_OBJECT, null);
                    }
                    parser.clearCurrentToken();
                    result = values;
                    break;
                }
                case START_ARRAY: {
                    ValueList values = ValueList.newInstance();
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        Value v = JacksonSerializationUtils.parseValue(parser, ctxt);
                        if (v == null) {
                            throw ctxt.wrongTokenException(parser, JsonToken.START_OBJECT, "Expected Value");
                        }
                        values.add(v);
                    }
                    if (JacksonSerializationUtils.getToken(parser) != JsonToken.END_ARRAY) {
                        throw ctxt.wrongTokenException(parser, JsonToken.END_ARRAY, null);
                    }
                    parser.clearCurrentToken();
                    result = values;
                    break;
                }
                default: {
                    throw ctxt.wrongTokenException(parser, JsonToken.START_OBJECT, "Expected Value");
                }
            }
            return result;
        }
        return null;
    }
}

