/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class JsonLongSerializer
extends JsonSerializer<Number> {
    private long MAX_VALUE = 999999999999999L;
    private long MIN_VALUE = -999999999999999L;

    public void serialize(Number value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null) {
            long longValue = value.longValue();
            if (longValue >= this.MIN_VALUE && longValue <= this.MAX_VALUE) {
                jgen.writeNumber(longValue);
            } else {
                jgen.writeString(value.toString());
            }
        } else {
            jgen.writeNull();
        }
    }
}

