/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.dbrain.data.Value;
import org.dbrain.data.ValueList;
import org.dbrain.data.ValueMap;

public class JsonValueSerializer
extends JsonSerializer<Value> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMap(ValueMap value, JsonGenerator w) throws IOException {
        w.writeStartObject();
        try {
            for (Map.Entry e : value.entrySet()) {
                w.writeFieldName((String)e.getKey());
                this.writeValue((Value)e.getValue(), w);
            }
        }
        finally {
            w.writeEndObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeList(ValueList value, JsonGenerator w) throws IOException {
        w.writeStartArray();
        try {
            for (Value e : value) {
                this.writeValue(e, w);
            }
        }
        finally {
            w.writeEndObject();
        }
    }

    public void writeValue(Value value, JsonGenerator w) throws IOException {
        if (value == null || value.isNull()) {
            w.writeNull();
        } else if (value instanceof ValueMap) {
            this.writeMap((ValueMap)value, w);
        } else if (value instanceof ValueList) {
            this.writeList((ValueList)value, w);
        } else {
            w.writeObject(value.getObject());
        }
    }

    public void serialize(Value value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        this.writeValue(value, jgen);
    }
}

