/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.dbrain.data.Path;
import org.dbrain.data.jackson.serializers.JacksonSerializationUtils;

public class PathDeserializer
extends JsonDeserializer<Path> {
    public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken t = JacksonSerializationUtils.getToken(jsonParser);
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (t == JsonToken.VALUE_STRING) {
            return Path.of(jsonParser.getText());
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.VALUE_STRING, "");
    }
}

