/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.type;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.dbrain.data.TypeRegistry;

public abstract class AbstractTypeRegistryIdResolver
implements TypeIdResolver {
    protected abstract TypeRegistry getTypeRegistry();

    public void init(JavaType baseType) {
        if (!this.getTypeRegistry().getBaseClass().isAssignableFrom(baseType.getRawClass())) {
            throw new IllegalArgumentException("Type " + baseType + " must be a subtype of " + this.getTypeRegistry().getBaseClass().getName());
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromBaseType() {
        String result = this.getTypeRegistry().getNameByType(this.getTypeRegistry().getBaseClass());
        if (result == null) {
            throw new IllegalStateException(this.getTypeRegistry().getBaseClass().getName() + " not registred in type registry.");
        }
        return result;
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        String result = this.getTypeRegistry().getNameByType(clazz);
        if (result == null) {
            throw new IllegalStateException(clazz.getName() + " not registred in type registry.");
        }
        return result;
    }

    public JavaType typeFromId(String id) {
        Class result = this.getTypeRegistry().getTypeByName(id);
        if (result == null) {
            throw new IllegalStateException(result.getName() + " not registred in type registry.");
        }
        return TypeFactory.defaultInstance().constructType(result);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        Class result = this.getTypeRegistry().getTypeByName(id);
        if (result == null) {
            throw new IllegalStateException(result.getName() + " not registred in type registry.");
        }
        return context.getTypeFactory().constructType(this.getTypeRegistry().getTypeByName(id));
    }
}

