/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jackson.type;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExistingPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dbrain.data.TypeRegistry;
import org.dbrain.data.jackson.type.TypeRegistryIdResolver;

public class TypeRegistryResolver
implements TypeResolverBuilder<TypeRegistryResolver> {
    private final TypeResolverBuilder delegate;
    private final List<Entry> entries;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TypeRegistryResolver of(TypeRegistry registry, String propertyName) {
        return TypeRegistryResolver.newBuilder().with(registry, propertyName).build();
    }

    private TypeRegistryResolver(TypeResolverBuilder delegate, List<Entry> entries) {
        this.delegate = delegate;
        this.entries = entries;
    }

    public Class<?> getDefaultImpl() {
        return this.delegate.getDefaultImpl();
    }

    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        Entry entry = this.lookupRegistry(baseType.getRawClass());
        if (entry != null) {
            TypeRegistryIdResolver idRes = new TypeRegistryIdResolver(entry.getRegistry());
            switch (entry.getInsertAs()) {
                case WRAPPER_ARRAY: {
                    return new AsArrayTypeSerializer((TypeIdResolver)idRes, null);
                }
                case PROPERTY: {
                    return new AsPropertyTypeSerializer((TypeIdResolver)idRes, null, entry.getName());
                }
                case WRAPPER_OBJECT: {
                    return new AsWrapperTypeSerializer((TypeIdResolver)idRes, null);
                }
                case EXTERNAL_PROPERTY: {
                    return new AsExternalTypeSerializer((TypeIdResolver)idRes, null, entry.getName());
                }
                case EXISTING_PROPERTY: {
                    return new AsExistingPropertyTypeSerializer((TypeIdResolver)idRes, null, entry.getName());
                }
            }
            throw new IllegalStateException();
        }
        return this.delegate.buildTypeSerializer(config, baseType, subtypes);
    }

    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        Entry entry = this.lookupRegistry(baseType.getRawClass());
        if (entry != null) {
            TypeRegistryIdResolver idRes = new TypeRegistryIdResolver(entry.getRegistry());
            switch (entry.getInsertAs()) {
                case WRAPPER_ARRAY: {
                    return new AsArrayTypeDeserializer(baseType, (TypeIdResolver)idRes, entry.getName(), entry.isVisible(), this.getDefaultImpl());
                }
                case PROPERTY: 
                case EXISTING_PROPERTY: {
                    return new AsPropertyTypeDeserializer(baseType, (TypeIdResolver)idRes, entry.getName(), entry.isVisible(), this.getDefaultImpl(), entry.getInsertAs());
                }
                case WRAPPER_OBJECT: {
                    return new AsWrapperTypeDeserializer(baseType, (TypeIdResolver)idRes, entry.getName(), entry.isVisible(), this.getDefaultImpl());
                }
                case EXTERNAL_PROPERTY: {
                    return new AsExternalTypeDeserializer(baseType, (TypeIdResolver)idRes, entry.getName(), entry.isVisible(), this.getDefaultImpl());
                }
            }
            throw new IllegalStateException();
        }
        return this.delegate.buildTypeDeserializer(config, baseType, subtypes);
    }

    public TypeRegistryResolver init(JsonTypeInfo.Id idType, TypeIdResolver res) {
        this.delegate.init(idType, res);
        return this;
    }

    public TypeRegistryResolver inclusion(JsonTypeInfo.As includeAs) {
        this.delegate.inclusion(includeAs);
        return this;
    }

    public TypeRegistryResolver typeProperty(String propName) {
        this.delegate.typeProperty(propName);
        return this;
    }

    public TypeRegistryResolver defaultImpl(Class<?> defaultImpl) {
        this.delegate.defaultImpl(defaultImpl);
        return this;
    }

    public TypeRegistryResolver typeIdVisibility(boolean isVisible) {
        this.delegate.typeIdVisibility(isVisible);
        return this;
    }

    public Entry lookupRegistry(Class clazz) {
        Entry result = null;
        for (Entry r : this.entries) {
            if (!r.getRegistry().getBaseClass().isAssignableFrom(clazz)) continue;
            if (result == null) {
                result = r;
                continue;
            }
            if (!result.getRegistry().getBaseClass().isAssignableFrom(r.getRegistry().getBaseClass())) continue;
            result = r;
        }
        return result;
    }

    public static class Builder {
        private TypeResolverBuilder delegate;
        private List<Entry> entries = new ArrayList<Entry>();

        public Builder withDelegate(TypeResolverBuilder<?> delegate) {
            this.delegate = delegate;
            return this;
        }

        public Builder with(TypeRegistry registry, String propertyName) {
            return this.with(registry, JsonTypeInfo.As.PROPERTY, propertyName);
        }

        public Builder with(TypeRegistry registry, JsonTypeInfo.As includeAs, String propertyName) {
            return this.with(registry, includeAs, propertyName, false);
        }

        public Builder with(TypeRegistry registry, JsonTypeInfo.As includeAs, String propertyName, boolean visible) {
            this.entries.add(new Entry(registry, includeAs, propertyName, visible));
            return this;
        }

        public TypeRegistryResolver build() {
            StdTypeResolverBuilder finalDelegate = this.delegate != null ? this.delegate : StdTypeResolverBuilder.noTypeInfoBuilder();
            return new TypeRegistryResolver((TypeResolverBuilder)finalDelegate, this.entries);
        }
    }

    private static class Entry {
        private TypeRegistry registry;
        private JsonTypeInfo.As insertAs;
        private String name;
        private boolean visible;

        public Entry(TypeRegistry registry, JsonTypeInfo.As insertAs, String name, boolean visible) {
            this.registry = registry;
            this.insertAs = insertAs;
            this.name = name;
            this.visible = visible;
        }

        public TypeRegistry getRegistry() {
            return this.registry;
        }

        public JsonTypeInfo.As getInsertAs() {
            return this.insertAs;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

