/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.dbrain.data.TextSerializer;
import org.dbrain.data.ValueList;

@Provider
public class ValueListBodyReader
implements MessageBodyReader<ValueList> {
    final TextSerializer serializer;

    public ValueListBodyReader(TextSerializer serializer) {
        this.serializer = serializer;
    }

    private static final Charset getCharset(MediaType m) {
        String name = m == null ? null : (String)m.getParameters().get("charset");
        return name == null ? Charset.forName("UTF-8") : Charset.forName(name);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ValueList.class.isAssignableFrom(type);
    }

    public ValueList readFrom(Class<ValueList> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStreamReader isr = new InputStreamReader(entityStream, ValueListBodyReader.getCharset(mediaType));
        return this.serializer.read(isr, ValueList.class);
    }
}

