/*
 * Decompiled with CFR 0.152.
 */
package org.dbrain.data.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.dbrain.data.TextSerializer;
import org.dbrain.data.ValueMap;

@Provider
@Consumes
public class ValueMapBodyReader
implements MessageBodyReader<ValueMap> {
    private final TextSerializer serializer;

    public ValueMapBodyReader(TextSerializer serializer) {
        this.serializer = serializer;
    }

    private static final Charset getCharset(MediaType m) {
        String name = m == null ? null : (String)m.getParameters().get("charset");
        return name == null ? Charset.forName("UTF-8") : Charset.forName(name);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ValueMap.class.isAssignableFrom(type);
    }

    public ValueMap readFrom(Class<ValueMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStreamReader isr = new InputStreamReader(entityStream, ValueMapBodyReader.getCharset(mediaType));
        return this.serializer.read(isr, ValueMap.class);
    }
}

