/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.clustering;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.commonsmath.package;
import org.ddahl.commonsmath.package$;
import org.ddahl.sdols.clustering.Cluster;
import org.ddahl.sdols.clustering.Cluster$;
import org.ddahl.sdols.clustering.Clustering;
import org.ddahl.sdols.clustering.Clustering$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class ClusteringSummary$ {
    public static ClusteringSummary$ MODULE$;
    private final Tuple2<Cluster<Null$>, Object> emptyTuple;

    static {
        new ClusteringSummary$();
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<Clustering<A>> clusterings) {
        int nItems = ((Clustering)clusterings.apply(0)).nItems();
        int[][] x = (int[][])Array$.MODULE$.ofDim(nItems, nItems, ClassTag$.MODULE$.Int());
        clusterings.foreach((Function1 & Serializable & scala.Serializable)clustering -> {
            clustering.foreach((Function1 & Serializable & scala.Serializable)cluster -> {
                ClusteringSummary$.$anonfun$expectedPairwiseAllocationMatrix$2(x$23, cluster);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        double cl = clusterings.length();
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map((Function1 & Serializable & scala.Serializable)x$1 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$1)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> (double)x$2 / cl, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public double[][] expectedPairwiseAllocationMatrix(int[][] clusterings) {
        int n = clusterings[0].length;
        int[][] x = (int[][])Array$.MODULE$.ofDim(n, n, ClassTag$.MODULE$.Int());
        for (int k = 0; k < clusterings.length; ++k) {
            int[] p = clusterings[k];
            for (int i = 0; i < n; ++i) {
                int[] xi = x[i];
                int pi = p[i];
                for (int j = 0; j < n; ++j) {
                    if (pi != p[j]) continue;
                    int n2 = j;
                    xi[n2] = xi[n2] + 1;
                }
            }
        }
        double cl = clusterings.length;
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map((Function1 & Serializable & scala.Serializable)x$3 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$3)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$4 -> (double)x$4 / cl, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public Tuple5<double[], double[][], int[], int[], int[]> confidenceComputations(int[] clustering, double[][] pam) {
        Clustering clustering2 = Clustering$.MODULE$.apply((JFunction1.mcII.sp & Serializable & scala.Serializable)i -> i, (Iterable<Object>)Predef$.MODULE$.wrapIntArray(clustering));
        double[] confidence = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), clustering2.nItems()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double[] pami = pam[i];
            Cluster cluster = clustering2.clusterFor(i);
            return BoxesRunTime.unboxToDouble((Object)cluster.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum, j) -> sum + pami[j])) / (double)cluster.size();
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        Map sizes = ((TraversableOnce)clustering2.map((Function1 & Serializable & scala.Serializable)cluster -> new Tuple2(cluster, (Object)BoxesRunTime.boxToInteger((int)cluster.size())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List clusters = (List)clustering2.toList().sortWith((Function2 & Serializable & scala.Serializable)(c1, c2) -> BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$confidenceComputations$5(sizes, c1, c2)));
        int[] confidenceMatrixLabels = (int[])((TraversableOnce)clusters.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$confidenceComputations$6(x$5)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        double[][] confidenceMatrix = (double[][])((TraversableOnce)clusters.map((Function1 & Serializable & scala.Serializable)cluster1 -> (double[])((TraversableOnce)clusters.map((Function1 & Serializable & scala.Serializable)cluster2 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$confidenceComputations$8(cluster1, pam, cluster2)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int[] exemplar = (int[])((TraversableOnce)((List)clusters.map((Function1 & Serializable & scala.Serializable)cluster -> (List)cluster.toList().sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(i, j) -> confidence[i] > confidence[j] ? true : (confidence[i] == confidence[j] ? i < j : false)), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$confidenceComputations$13(x$6)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        int[] orderList = (int[])((TraversableOnce)((List)clusters.zip((GenIterable)Predef$.MODULE$.wrapIntArray(exemplar), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x -> this.findBest$1(((Cluster)x._1()).x().$minus((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())).toList(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{x._2$mcI$sp()})), pam), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        return new Tuple5((Object)confidence, (Object)confidenceMatrix, (Object)confidenceMatrixLabels, (Object)orderList, (Object)exemplar);
    }

    public <A> double lowerBoundVariationOfInformation(Clustering<A> clustering, double[][] pam) {
        int nItems = clustering.nItems();
        double sum1 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int sum2 = 0;
            double sum3 = 0.0;
            double sum4 = 0.0;
            for (int j = 0; j < nItems; ++j) {
                sum2 += clustering.paired(i, j) ? 1 : 0;
                sum3 += pam[i][j];
                sum4 += clustering.paired(i, j) ? pam[i][j] : 0.0;
            }
            sum1 += FastMath.log((double)2.0, (double)sum2) + FastMath.log((double)2.0, (double)sum3) - (double)2 * FastMath.log((double)2.0, (double)sum4);
        }
        return sum1 / (double)nItems;
    }

    /*
     * WARNING - void declaration
     */
    private <A> double lowerBoundVariationOfInformationEngine(Clustering<A> clustering, double[][] pam) {
        void var3_3;
        double sum = 0.0;
        Cluster[] clusters = (Cluster[])clustering.toArray(ClassTag$.MODULE$.apply(Cluster.class));
        for (int k = 0; k < clusters.length; ++k) {
            int[] cluster = (int[])clusters[k].toArray(ClassTag$.MODULE$.Int());
            sum += (double)cluster.length * FastMath.log((double)2.0, (double)cluster.length);
            double sum2 = 0.0;
            for (int ii = 0; ii < cluster.length; ++ii) {
                double sum3 = 0.0;
                double[] pamii = pam[cluster[ii]];
                for (int jj = 0; jj < cluster.length; ++jj) {
                    sum3 += pamii[cluster[jj]];
                }
                sum2 += FastMath.log((double)2.0, (double)sum3);
            }
            sum -= (double)2 * sum2;
        }
        return (double)var3_3;
    }

    public <A> double sumOfAbsolutesSlow(Clustering<A> clustering, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(clustering.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$11 -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$11)))).sum();
    }

    public <A> double sumOfSquaresSlow(Clustering<A> clustering, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(clustering.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x)).sum();
    }

    private <A> double binderOffset(double[][] pam, Function1<Object, Object> f) {
        double offset = 0.0;
        for (int i = 1; i < pam.length; ++i) {
            double[] pi = pam[i];
            for (int j = 0; j < i; ++j) {
                offset += f.apply$mcDD$sp(pi[j]);
            }
        }
        return (double)2 * offset;
    }

    public <A> double sumOfAbsolutes(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam)).map((Function1 & Serializable & scala.Serializable)x$12 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$12)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> (double)2 - (double)4 * x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x))) + this.binderEngine(clustering, pamTransform);
    }

    public <A> double sumOfSquares(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam)).map((Function1 & Serializable & scala.Serializable)x$13 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$13)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> (double)2 - (double)4 * x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x) + this.binderEngine(clustering, pamTransform);
    }

    private <A> double binderEngine(Clustering<A> clustering, double[][] pamTransform) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        clustering.foreach((Function1 & Serializable & scala.Serializable)cluster -> {
            ClusteringSummary$.$anonfun$binderEngine$1(pamTransform, sum, cluster);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    private Tuple2<Cluster<Null$>, Object> emptyTuple() {
        return this.emptyTuple;
    }

    private List<Tuple2<Cluster<Null$>, Object>> binderShortcutEngine(int i, Clustering<Null$> clusteringWithoutI, int maxSize, double[][] pamTransform) {
        List list;
        double[] pamTransformi = pamTransform[i];
        List candidates = ((TraversableOnce)clusteringWithoutI.map((Function1 & Serializable & scala.Serializable)cluster -> new Tuple2(cluster, (Object)cluster.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum, j) -> sum + pamTransformi[j])), Iterable$.MODULE$.canBuildFrom())).toList();
        if (maxSize <= 0 || clusteringWithoutI.size() < maxSize) {
            Tuple2<Cluster<Null$>, Object> tuple2 = this.emptyTuple();
            list = candidates.$colon$colon(tuple2);
        } else {
            list = candidates;
        }
        return list;
    }

    private List<Tuple2<Cluster<Null$>, Object>> lowerBoundVariationOfInformationShortcutEngine(int i, Clustering<Null$> clusteringWithoutI, int maxSize, double[][] pam) {
        List list;
        List candidates = ((TraversableOnce)clusteringWithoutI.map((Function1 & Serializable & scala.Serializable)cluster -> new Tuple2(cluster, (Object)BoxesRunTime.boxToDouble((double)MODULE$.lowerBoundVariationOfInformationEngine(clusteringWithoutI.add(i, (Cluster<Null$>)cluster), pam))), Iterable$.MODULE$.canBuildFrom())).toList();
        if (maxSize <= 0 || clusteringWithoutI.size() < maxSize) {
            Tuple2 tuple2 = new Tuple2(Cluster$.MODULE$.empty(null), (Object)BoxesRunTime.boxToDouble((double)this.lowerBoundVariationOfInformationEngine(clusteringWithoutI.add(i, Cluster$.MODULE$.empty(null)), pam)));
            list = candidates.$colon$colon((Object)tuple2);
        } else {
            list = candidates;
        }
        return list;
    }

    public <A> Clustering<A> minAmongDraws(Seq<Clustering<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.expectedPairwiseAllocationMatrix((Seq)candidates));
        Tuple3<Function2<Clustering<A>, double[][], Object>, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>, double[][]> tuple3 = this.getLoss(maxSize, loss, pam);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 lossEngine = (Function2)tuple3._1();
        Function2 shortcutEngine = (Function2)tuple3._2();
        double[][] pamTransform = (double[][])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)lossEngine, (Object)shortcutEngine, (Object)pamTransform);
        Tuple3 tuple33 = tuple32;
        Function2 lossEngine2 = (Function2)tuple33._1();
        Function2 shortcutEngine2 = (Function2)tuple33._2();
        double[][] pamTransform2 = (double[][])tuple33._3();
        GenSeq iter = multicore ? (GenSeq)candidates.par() : candidates;
        return (Clustering)iter.minBy((Function1 & Serializable & scala.Serializable)clustering -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$minAmongDraws$2(maxSize, lossEngine2, pamTransform2, clustering)), (Ordering)Ordering.Double$.MODULE$);
    }

    private Clustering<Null$> sequentiallyAllocatedLatentStructureOptimizationOld(Clustering<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<Clustering<Null$>, double[][], Object> lossEngine) {
        ObjectRef clustering = ObjectRef.create(initial);
        permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List list;
            List candidates = ((TraversableOnce)((Clustering)clustering$1.elem).map((Function1 & Serializable & scala.Serializable)cluster -> ((Clustering)clustering$1.elem).add(i, cluster), Iterable$.MODULE$.canBuildFrom())).toList();
            if (maxSize <= 0 || ((Clustering)clustering$1.elem).size() < maxSize) {
                Clustering<Object> clustering = ((Clustering)clustering$1.elem).add(Cluster$.MODULE$.apply(null, i));
                list = candidates.$colon$colon(clustering);
            } else {
                list = candidates;
            }
            List candidates2 = list;
            clustering$1.elem = (Clustering)candidates2.minBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimizationOld$3(lossEngine, pamTransform, x$18)), (Ordering)Ordering.Double$.MODULE$);
        });
        return (Clustering)clustering.elem;
    }

    public Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> mkShortcutEngineBinder(int maxSize, double[][] pamTransform) {
        return (Function2 & Serializable & scala.Serializable)(i, clusteringWithoutI) -> ClusteringSummary$.MODULE$.binderShortcutEngine(BoxesRunTime.unboxToInt((Object)i), clusteringWithoutI, maxSize, pamTransform);
    }

    public Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> mkShortcutEngineLowerBoundVariationOfInformation(int maxSize, double[][] pam) {
        return (Function2 & Serializable & scala.Serializable)(i, clusteringWithoutI) -> ClusteringSummary$.MODULE$.lowerBoundVariationOfInformationShortcutEngine(BoxesRunTime.unboxToInt((Object)i), clusteringWithoutI, maxSize, pam);
    }

    private Tuple2<Clustering<Null$>, Object> sequentiallyAllocatedLatentStructureOptimization(Clustering<Null$> initial, int maxScans, List<Object> permutation, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>> engine) {
        ObjectRef clustering = ObjectRef.create(initial);
        BooleanRef firstPass = BooleanRef.create((boolean)true);
        boolean notDone = true;
        int scanCounter = -1;
        while (firstPass.elem || notDone) {
            ++scanCounter;
            Clustering previousClustering = (Clustering)clustering.elem;
            permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (!firstPass$1.elem) {
                    clustering$2.elem = ((Clustering)clustering$2.elem).remove(i);
                }
                List candidates = (List)engine.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)((Clustering)clustering$2.elem));
                clustering$2.elem = ((Clustering)clustering$2.elem).add(i, (Cluster)((Tuple2)candidates.minBy((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))._1());
            });
            if (firstPass.elem) {
                firstPass.elem = false;
            }
            Clustering clustering2 = (Clustering)clustering.elem;
            Clustering clustering3 = previousClustering;
            notDone = (clustering2 == null ? clustering3 != null : !((Object)clustering2).equals(clustering3)) && scanCounter < maxScans;
        }
        return new Tuple2((Object)((Clustering)clustering.elem), (Object)BoxesRunTime.boxToInteger((int)scanCounter));
    }

    private <A> Tuple3<Function2<Clustering<A>, double[][], Object>, Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>, double[][]> getLoss(int maxSize, String loss, double[][] pam2) {
        Tuple3 tuple3;
        String string = loss;
        boolean bl = "binder".equals(string) ? true : ("squaredError".equals(string) ? true : "absoluteError".equals(string));
        if (bl) {
            double[][] pamTransform2 = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam2)).map((Function1 & Serializable & scala.Serializable)x$20 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$20)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> 0.5 - x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
            tuple3 = new Tuple3((Function2 & Serializable & scala.Serializable)(clustering, pamTransform) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.binderEngine(clustering, pamTransform)), this.mkShortcutEngineBinder(maxSize, pamTransform2), (Object)pamTransform2);
        } else if ("lowerBoundVariationOfInformation".equals(string)) {
            tuple3 = new Tuple3((Function2 & Serializable & scala.Serializable)(clustering, pam) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.lowerBoundVariationOfInformationEngine(clustering, pam)), this.mkShortcutEngineLowerBoundVariationOfInformation(maxSize, pam2), (Object)pam2);
        } else {
            throw new MatchError((Object)string);
        }
        return tuple3;
    }

    public Tuple3<Clustering<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, int maxScans, boolean multicore, String loss, boolean useOldImplementation) {
        Tuple3 tuple3 = this.getLoss(maxSize, loss, pam);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Function2 lossEngine = (Function2)tuple3._1();
        Function2 shortcutEngine = (Function2)tuple3._2();
        double[][] pamTransform = (double[][])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)lossEngine, (Object)shortcutEngine, (Object)pamTransform);
        Tuple3 tuple33 = tuple32;
        Function2 lossEngine2 = (Function2)tuple33._1();
        Function2 shortcutEngine2 = (Function2)tuple33._2();
        double[][] pamTransform2 = (double[][])tuple33._3();
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
        Clustering empty = Clustering$.MODULE$.empty();
        int nCores = multicore ? Runtime.getRuntime().availableProcessors() : 1;
        int nCandidatesPerThread = (nCandidates - 1) / nCores + 1;
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        List futures = (List)List$.MODULE$.fill(nCores, (Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int counter;
            double minScore = Double.POSITIVE_INFINITY;
            Tuple2 best = new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)-1));
            for (counter = 0; counter < nCandidatesPerThread && (double)(System.currentTimeMillis() - start) <= budgetInMillis; ++counter) {
                List permutation = (List)rng.shuffle((TraversableOnce)ints, List$.MODULE$.canBuildFrom());
                Tuple2 tuple2 = !useOldImplementation ? MODULE$.sequentiallyAllocatedLatentStructureOptimization(empty, maxScans, (List<Object>)permutation, (Function2<Object, Clustering<Null$>, List<Tuple2<Cluster<Null$>, Object>>>)shortcutEngine2) : new Tuple2(MODULE$.sequentiallyAllocatedLatentStructureOptimizationOld(empty, maxSize, (List<Object>)permutation, pamTransform2, (Function2<Clustering<Null$>, double[][], Object>)lossEngine2), (Object)BoxesRunTime.boxToInteger((int)-1));
                Tuple2 candidate = tuple2;
                double score = BoxesRunTime.unboxToDouble((Object)lossEngine2.apply(candidate._1(), (Object)pamTransform2));
                if (!(score < minScore)) continue;
                minScore = score;
                best = candidate;
            }
            return new Tuple4(best._1(), (Object)BoxesRunTime.boxToInteger((int)best._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)minScore), (Object)BoxesRunTime.boxToInteger((int)counter));
        }, ExecutionContext.Implicits$.MODULE$.global()));
        List seq = (List)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        int nCandidatesInPractice = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(sum, tuple) -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$6(BoxesRunTime.unboxToInt((Object)sum), tuple))));
        Tuple4 best = (Tuple4)seq.minBy((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$7(x$22)), (Ordering)Ordering.Double$.MODULE$);
        return new Tuple3(best._1(), best._2(), (Object)BoxesRunTime.boxToInteger((int)nCandidatesInPractice));
    }

    public static final /* synthetic */ void $anonfun$expectedPairwiseAllocationMatrix$2(int[][] x$23, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            int ii = y[i];
            for (int j = i + 1; j < y.length; ++j) {
                int jj = y[j];
                int[] nArray = x$23[ii];
                nArray[jj] = nArray[jj] + 1;
                int[] nArray2 = x$23[jj];
                nArray2[ii] = nArray2[ii] + 1;
            }
            int[] nArray = x$23[ii];
            nArray[ii] = nArray[ii] + 1;
        }
    }

    public static final /* synthetic */ boolean $anonfun$confidenceComputations$5(Map sizes$1, Cluster c1, Cluster c2) {
        return BoxesRunTime.unboxToInt((Object)sizes$1.apply((Object)c1)) > BoxesRunTime.unboxToInt((Object)sizes$1.apply((Object)c2));
    }

    public static final /* synthetic */ int $anonfun$confidenceComputations$6(Cluster x$5) {
        return BoxesRunTime.unboxToInt(x$5.parameter());
    }

    public static final /* synthetic */ double $anonfun$confidenceComputations$8(Cluster cluster1$1, double[][] pam$1, Cluster cluster2) {
        return BoxesRunTime.unboxToDouble((Object)cluster1$1.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum1, i) -> {
            double[] pami = pam$1[i];
            return sum1 + BoxesRunTime.unboxToDouble((Object)cluster2.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum2, j) -> sum2 + pami[j]));
        })) / (double)(cluster1$1.size() * cluster2.size());
    }

    public static final /* synthetic */ int $anonfun$confidenceComputations$13(List x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$confidenceComputations$15(List members$1, double[][] pam$1, int y) {
        return new Tuple2.mcDI.sp(BoxesRunTime.unboxToDouble((Object)members$1.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum, j) -> sum + pam$1[y][j])), y);
    }

    public static final /* synthetic */ boolean $anonfun$confidenceComputations$17(Tuple2 x$7, Tuple2 x$8) {
        return x$7._1$mcD$sp() > x$8._1$mcD$sp();
    }

    private final List findBest$1(List candidates, List members, double[][] pam$1) {
        while (!candidates.isEmpty()) {
            int best;
            int n = best = ((Tuple2)((IterableLike)((SeqLike)candidates.map((Function1 & Serializable & scala.Serializable)y -> ClusteringSummary$.$anonfun$confidenceComputations$15(members, pam$1, BoxesRunTime.unboxToInt((Object)y)), List$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$confidenceComputations$17(x$7, x$8)))).head())._2$mcI$sp();
            members = members.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            candidates = (List)candidates.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 == best);
        }
        return members;
    }

    public static final /* synthetic */ void $anonfun$binderEngine$1(double[][] pamTransform$1, DoubleRef sum$1, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            double[] xx = pamTransform$1[y[i]];
            for (int j = i + 1; j < y.length; ++j) {
                sum$1.elem += xx[y[j]];
            }
        }
    }

    public static final /* synthetic */ double $anonfun$minAmongDraws$2(int maxSize$1, Function2 lossEngine$1, double[][] pamTransform$2, Clustering clustering) {
        return maxSize$1 > 0 && clustering.size() > maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)lossEngine$1.apply((Object)clustering, (Object)pamTransform$2));
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimizationOld$3(Function2 lossEngine$2, double[][] pamTransform$3, Clustering x$18) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$2.apply((Object)x$18, (Object)pamTransform$3));
    }

    public static final /* synthetic */ int $anonfun$sequentiallyAllocatedLatentStructureOptimization$6(int sum, Tuple4 tuple) {
        return sum + BoxesRunTime.unboxToInt((Object)tuple._4());
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$7(Tuple4 x$22) {
        return BoxesRunTime.unboxToDouble((Object)x$22._3());
    }

    private ClusteringSummary$() {
        MODULE$ = this;
        this.emptyTuple = new Tuple2(Cluster$.MODULE$.empty(null), (Object)BoxesRunTime.boxToDouble((double)0.0));
    }
}

