/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.featureallocation;

import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.ddahl.commonsmath.package;
import org.ddahl.commonsmath.package$;
import org.ddahl.sdols.featureallocation.Feature;
import org.ddahl.sdols.featureallocation.Feature$;
import org.ddahl.sdols.featureallocation.FeatureAllocation;
import org.ddahl.sdols.featureallocation.FeatureAllocation$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.parallel.ParIterableLike;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class FeatureAllocationSummary$ {
    public static FeatureAllocationSummary$ MODULE$;

    static {
        new FeatureAllocationSummary$();
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<FeatureAllocation<A>> fas) {
        if (fas.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        int nItems = ((FeatureAllocation)fas.head()).nItems();
        Array2DRowRealMatrix zero = package.MatrixFactory$.MODULE$.apply(nItems, nItems);
        return package$.MODULE$.RichArray2DRowRealMatrix((Array2DRowRealMatrix)((ParIterableLike)fas.par()).aggregate((Function0 & Serializable & scala.Serializable)() -> zero, (Function2 & Serializable & scala.Serializable)(sum, x) -> package$.MODULE$.RichArray2DRowRealMatrix(sum).$plus(x.pairwiseAllocationMatrix()), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> package$.MODULE$.RichArray2DRowRealMatrix(x$1).$plus(x$2))).$colon$div((double)fas.size()).getData();
    }

    public <A> double sumOfSquaresSlow(FeatureAllocation<A> fa, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x)).sum();
    }

    public <A> double sumOfAbsolutesSlow(FeatureAllocation<A> fa, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(fa.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$3)))).sum();
    }

    private <A> double engine(int[][] counts, double[][] pam, Function1<Object, Object> f) {
        int nItems = pam.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int[] countsi = counts[i];
            double[] pami = pam[i];
            sum1 += f.apply$mcDD$sp((double)countsi[i] - pami[i]);
            for (int j = 0; j < i; ++j) {
                sum2 += f.apply$mcDD$sp((double)countsi[j] - pami[j]);
            }
        }
        return sum1 + (double)2 * sum2;
    }

    public <A> double sumOfSquares(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x);
    }

    public <A> double sumOfAbsolutes(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x)));
    }

    public <A> FeatureAllocation<A> minAmongDraws(Seq<FeatureAllocation<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.expectedPairwiseAllocationMatrix((Seq)candidates));
        Function2 lossEngine = this.getLoss(loss);
        GenSeq iter = multicore ? (GenSeq)candidates.par() : candidates;
        return (FeatureAllocation)iter.minBy((Function1 & Serializable & scala.Serializable)featureAllocation -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$minAmongDraws$2(maxSize, lossEngine, pam, featureAllocation)), (Ordering)Ordering.Double$.MODULE$);
    }

    private ListBuffer<FeatureAllocation<Null$>> expand(FeatureAllocation<Null$> fa, List<Feature<Null$>> availableFeatures, int i) {
        ListBuffer listBuffer;
        if (availableFeatures.isEmpty()) {
            listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            FeatureAllocation<Null$> faPlus = fa.add(i, (Feature)availableFeatures.head());
            List tail = (List)availableFeatures.tail();
            listBuffer = tail.isEmpty() ? (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FeatureAllocation[]{fa, faPlus})) : (ListBuffer)this.expand(fa, (List<Feature<Null$>>)tail, i).$plus$plus(this.expand(faPlus, (List<Feature<Null$>>)tail, i));
        }
        return listBuffer;
    }

    private FeatureAllocation<Null$> padWithFeature(FeatureAllocation<Null$> fa, Feature<Null$> f, int nTimes) {
        FeatureAllocation<Null$> fa2 = fa;
        for (int j = 0; j < nTimes; ++j) {
            fa2 = fa2.add(f);
        }
        return fa2;
    }

    private FeatureAllocation<Null$> sequentiallyAllocatedLatentStructureOptimization(FeatureAllocation<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<FeatureAllocation<Null$>, double[][], Object> lossEngine) {
        int max = maxSize <= 0 ? Integer.MAX_VALUE : maxSize;
        ObjectRef fa = ObjectRef.create(initial);
        permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            FeatureAllocation featureAllocation;
            Feature<Object> singleton = Feature$.MODULE$.apply(null, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{i}));
            int expectedNumberOfFeatures = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(pamTransform[i][i]));
            if (((FeatureAllocation)fa$1.elem).isEmpty()) {
                featureAllocation = MODULE$.padWithFeature((FeatureAllocation)fa$1.elem, singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures), max));
            } else {
                ListBuffer candidates = MODULE$.expand((FeatureAllocation)fa$1.elem, ((FeatureAllocation)fa$1.elem).toList(), i);
                int residualCapacity = maxSize - ((FeatureAllocation)fa$1.elem).nFeatures();
                ListBuffer candidates2 = residualCapacity > 0 ? (ListBuffer)candidates.map((Function1 & Serializable & scala.Serializable)fa2 -> MODULE$.padWithFeature((FeatureAllocation<Null$>)fa2, (Feature<Null$>)singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures - fa2.nFeatures(i)), residualCapacity)), ListBuffer$.MODULE$.canBuildFrom()) : candidates;
                featureAllocation = (FeatureAllocation)candidates2.minBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$3(lossEngine, pamTransform, x$4)), (Ordering)Ordering.Double$.MODULE$);
            }
            fa$1.elem = featureAllocation;
        });
        return (FeatureAllocation)fa.elem;
    }

    private <A> Function2<FeatureAllocation<A>, double[][], Object> getLoss(String loss) {
        Function2 & Serializable & scala.Serializable intersect;
        String string = loss;
        if ("squaredError".equals(string)) {
            intersect = (Function2 & Serializable & scala.Serializable)(fa, pam) -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.MODULE$.sumOfSquares(fa, pam));
        } else if ("absoluteError".equals(string)) {
            intersect = (Function2 & Serializable & scala.Serializable)(fa, pam) -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.MODULE$.sumOfAbsolutes(fa, pam));
        } else {
            throw new MatchError((Object)string);
        }
        return intersect;
    }

    public Tuple3<FeatureAllocation<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, int maxScans, boolean multicore, String loss) {
        Function2 lossEngine = this.getLoss(loss);
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
        FeatureAllocation empty = FeatureAllocation$.MODULE$.empty(nItems);
        int nCores = multicore ? Runtime.getRuntime().availableProcessors() : 1;
        int nCandidatesPerThread = (nCandidates - 1) / nCores + 1;
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        List futures = (List)List$.MODULE$.fill(nCores, (Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int counter;
            double minScore = Double.POSITIVE_INFINITY;
            Tuple2 best = new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)-1));
            for (counter = 0; counter < nCandidatesPerThread && (double)(System.currentTimeMillis() - start) <= budgetInMillis; ++counter) {
                List permutation = (List)rng.shuffle((TraversableOnce)ints, List$.MODULE$.canBuildFrom());
                Tuple2 candidate = new Tuple2(MODULE$.sequentiallyAllocatedLatentStructureOptimization(empty, maxSize, (List<Object>)permutation, pam, (Function2<FeatureAllocation<Null$>, double[][], Object>)lossEngine), (Object)BoxesRunTime.boxToInteger((int)-1));
                double score = BoxesRunTime.unboxToDouble((Object)lossEngine.apply(candidate._1(), (Object)pam));
                if (!(score < minScore)) continue;
                minScore = score;
                best = candidate;
            }
            return new Tuple4(best._1(), (Object)BoxesRunTime.boxToInteger((int)best._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)minScore), (Object)BoxesRunTime.boxToInteger((int)counter));
        }, ExecutionContext.Implicits$.MODULE$.global()));
        List seq = (List)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        int nCandidatesInPractice = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(sum, tuple) -> BoxesRunTime.boxToInteger((int)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$7(BoxesRunTime.unboxToInt((Object)sum), tuple))));
        Tuple4 best = (Tuple4)seq.minBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)FeatureAllocationSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$8(x$5)), (Ordering)Ordering.Double$.MODULE$);
        return new Tuple3(best._1(), best._2(), (Object)BoxesRunTime.boxToInteger((int)nCandidatesInPractice));
    }

    public static final /* synthetic */ double $anonfun$minAmongDraws$2(int maxSize$1, Function2 lossEngine$1, double[][] pam$1, FeatureAllocation featureAllocation) {
        return maxSize$1 > 0 && featureAllocation.size() > maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)lossEngine$1.apply((Object)featureAllocation, (Object)pam$1));
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$3(Function2 lossEngine$2, double[][] pamTransform$1, FeatureAllocation x$4) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$2.apply((Object)x$4, (Object)pamTransform$1));
    }

    public static final /* synthetic */ int $anonfun$sequentiallyAllocatedLatentStructureOptimization$7(int sum, Tuple4 tuple) {
        return sum + BoxesRunTime.unboxToInt((Object)tuple._4());
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$8(Tuple4 x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5._3());
    }

    private FeatureAllocationSummary$() {
        MODULE$ = this;
    }
}

