/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.io.torch7.ParseTorch7;
import deepboof.io.torch7.TorchType;
import java.io.IOException;

public class ParseAsciiTorch7
extends ParseTorch7 {
    byte[] buffer = new byte[1024];

    @Override
    public int[] readShape(int dimension) throws IOException {
        String line = this.readInnerString();
        String[] words = line.split(" ");
        if (words.length != dimension) {
            throw new IOException("Unexpected number of words");
        }
        int[] shape = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            shape[i] = Integer.parseInt(words[i]);
        }
        return shape;
    }

    @Override
    public TorchType readType() throws IOException {
        return TorchType.valueToType(this.readS32());
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readS32() != 0;
    }

    @Override
    public double readDouble() throws IOException {
        return Double.parseDouble(this.readInnerString());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.parseFloat(this.readInnerString());
    }

    @Override
    public String readString() throws IOException {
        int length = Integer.parseInt(this.readInnerString());
        if (length > this.buffer.length) {
            throw new IOException("Need to increase size of buffer to read this string");
        }
        this.input.readFully(this.buffer, 0, length + 1);
        if (this.buffer[length] != 10) {
            throw new IOException("Unexpected string ending");
        }
        return new String(this.buffer, 0, length);
    }

    @Override
    public long readS64() throws IOException {
        return Integer.parseInt(this.readInnerString());
    }

    @Override
    public int readS32() throws IOException {
        return Integer.parseInt(this.readInnerString());
    }

    @Override
    public int readU8() throws IOException {
        return Integer.parseInt(this.readInnerString());
    }

    @Override
    public void readArrayDouble(int size, double[] storage) throws IOException {
        String line = this.readInnerString();
        String[] words = line.split(" ");
        if (words.length != size) {
            throw new IOException("Unexpected number of words " + size + " found " + words.length);
        }
        for (int i = 0; i < size; ++i) {
            storage[i] = words[i].endsWith("nan") ? Double.NaN : Double.parseDouble(words[i]);
        }
    }

    @Override
    public void readArrayFloat(int size, float[] storage) throws IOException {
        String line = this.readInnerString();
        String[] words = line.split(" ");
        if (words.length != size) {
            throw new IOException("Unexpected number of words " + size + " found " + words.length);
        }
        for (int i = 0; i < size; ++i) {
            storage[i] = Float.parseFloat(words[i]);
        }
    }

    @Override
    public void readArrayChar(int size, char[] storage) throws IOException {
        for (int i = 0; i < size / 2; ++i) {
            storage[i] = (char)Short.reverseBytes(this.input.readShort());
        }
        if (size % 2 == 1) {
            storage[size / 2] = (char)this.input.readByte();
        }
        this.input.readByte();
    }

    @Override
    public void readArrayByte(int size, byte[] storage) throws IOException {
        this.input.readFully(storage, 0, size);
        this.input.readByte();
    }

    private String readInnerString() throws IOException {
        int value;
        int length = 0;
        while ((value = this.input.readUnsignedByte()) != 10) {
            this.buffer[length++] = (byte)value;
            if (this.buffer.length != length) continue;
            this.growBuffer();
        }
        return new String(this.buffer, 0, length);
    }

    private void growBuffer() {
        byte[] tmp = new byte[this.buffer.length + 1024];
        System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
        this.buffer = tmp;
    }
}

