/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io;

import com.github.axet.wget.WGet;
import com.github.axet.wget.info.DownloadInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;

public class DeepBoofDataBaseOps {
    public static File downloadModel(List<String> addresses, File destination) {
        File pathDirectory = null;
        if (!destination.exists()) {
            destination.mkdirs();
        }
        for (String address : addresses) {
            try {
                String fileName = new File(address).getName();
                pathDirectory = new File(destination, fileName.substring(0, fileName.length() - 4));
                if (pathDirectory.exists()) break;
                DeepBoofDataBaseOps.download(address, destination);
                DeepBoofDataBaseOps.decompressZip(new File(destination, fileName), destination, true);
                break;
            }
            catch (RuntimeException e) {
                pathDirectory = null;
            }
        }
        if (pathDirectory == null) {
            throw new RuntimeException("Failed to download model");
        }
        return pathDirectory;
    }

    public static File download(String src, File dstDir) {
        try {
            File dst = new File(dstDir, new File(new URL(src).getFile()).getName());
            System.out.println("Downloading " + src + "  to " + dst);
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                throw new RuntimeException("Can't create directories");
            }
            DownloadInfo info = new DownloadInfo(new URL(src));
            info.extract();
            WGet w = new WGet(info, dst);
            w.download();
            return WGet.calcName((URL)new URL(src), (File)dst);
        }
        catch (RuntimeException | MalformedURLException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public static void decompressTGZ(File src, File dst) {
        Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
        try {
            archiver.extract(src, dst);
        }
        catch (IOException e) {
            System.out.println("Failed to decompress.  " + e.getMessage());
            System.exit(1);
        }
    }

    public static void decompressZip(File src, File dst, boolean deleteZip) {
        try {
            ZipFile zipFile = new ZipFile(src);
            zipFile.extractAll(dst.getAbsolutePath());
            if (deleteZip && !src.delete()) {
                System.err.println("Failed to delete " + src.getName());
            }
        }
        catch (ZipException e) {
            System.err.println("Failed to decompress.  " + e.getMessage());
            System.exit(1);
        }
    }

    public static void moveInsideAndDeleteDir(File srcDir, File dstDir) {
        if (!srcDir.isDirectory()) {
            System.out.println(srcDir.getName() + " isn't a directory");
            System.exit(1);
        }
        if (!dstDir.isDirectory()) {
            System.out.println(dstDir.getName() + " isn't a directory");
            System.exit(1);
        }
        for (File f : srcDir.listFiles()) {
            try {
                Files.move(f.toPath(), new File(dstDir, f.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                System.out.println("Failed to move.  " + e.getMessage());
                System.exit(1);
            }
        }
        if (!srcDir.delete()) {
            System.err.println("Failed to cleanup " + srcDir.getName());
        }
    }
}

