/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.io.torch7.ParseTorch7;
import deepboof.io.torch7.TorchType;
import java.io.IOException;

public class ParseBinaryTorch7
extends ParseTorch7 {
    boolean littleEndian = true;

    public ParseBinaryTorch7(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public ParseBinaryTorch7() {
    }

    @Override
    public int[] readShape(int dimension) throws IOException {
        int[] shape = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            shape[i] = (int)this.readS64();
        }
        return shape;
    }

    @Override
    public TorchType readType() throws IOException {
        return TorchType.valueToType(this.readS32());
    }

    @Override
    public boolean readBoolean() throws IOException {
        int value = this.readS32();
        return value == 1;
    }

    @Override
    public double readDouble() throws IOException {
        long value = this.input.readLong();
        if (this.littleEndian) {
            value = Long.reverseBytes(value);
        }
        return Double.longBitsToDouble(value);
    }

    @Override
    public float readFloat() throws IOException {
        int value = this.input.readInt();
        if (this.littleEndian) {
            value = Integer.reverseBytes(value);
        }
        return Float.intBitsToFloat(value);
    }

    @Override
    public String readString() throws IOException {
        int length = this.readS32();
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (byte)this.readU8();
        }
        return new String(array);
    }

    @Override
    public long readS64() throws IOException {
        if (this.littleEndian) {
            return Long.reverseBytes(this.input.readLong());
        }
        return this.input.readLong();
    }

    @Override
    public int readS32() throws IOException {
        if (this.littleEndian) {
            return Integer.reverseBytes(this.input.readInt());
        }
        return this.input.readInt();
    }

    @Override
    public int readU8() throws IOException {
        return this.input.readByte() & 0xFF;
    }

    @Override
    public void readArrayDouble(int size, double[] storage) throws IOException {
        byte[] tmp = new byte[size * 8];
        this.input.readFully(tmp);
        if (this.littleEndian) {
            int idx = 0;
            int i = 0;
            while (i < size) {
                long a = (long)(tmp[idx] & 0xFF | (tmp[idx + 1] & 0xFF) << 8 | (tmp[idx + 2] & 0xFF) << 16) | (long)(tmp[idx + 3] & 0xFF) << 24;
                long b = (long)(tmp[idx + 4] & 0xFF | (tmp[idx + 5] & 0xFF) << 8 | (tmp[idx + 6] & 0xFF) << 16) | (long)(tmp[idx + 7] & 0xFF) << 24;
                storage[i] = Double.longBitsToDouble(b << 32 | a);
                ++i;
                idx += 8;
            }
        } else {
            int idx = 0;
            int i = 0;
            while (i < size) {
                long a = (long)(tmp[idx + 3] & 0xFF | (tmp[idx + 2] & 0xFF) << 8 | (tmp[idx + 1] & 0xFF) << 16) | (long)(tmp[idx] & 0xFF) << 24;
                long b = (long)(tmp[idx + 7] & 0xFF | (tmp[idx + 6] & 0xFF) << 8 | (tmp[idx + 5] & 0xFF) << 16) | (long)(tmp[idx + 4] & 0xFF) << 24;
                storage[i] = Double.longBitsToDouble(a << 32 | b);
                ++i;
                idx += 8;
            }
        }
    }

    @Override
    public void readArrayFloat(int size, float[] storage) throws IOException {
        byte[] tmp = new byte[size * 4];
        this.input.readFully(tmp);
        if (this.littleEndian) {
            int idx = 0;
            int i = 0;
            while (i < size) {
                int v = tmp[idx] & 0xFF | (tmp[idx + 1] & 0xFF) << 8 | (tmp[idx + 2] & 0xFF) << 16 | (tmp[idx + 3] & 0xFF) << 24;
                storage[i] = Float.intBitsToFloat(v);
                ++i;
                idx += 4;
            }
        } else {
            int idx = 0;
            int i = 0;
            while (i < size) {
                int v = tmp[idx + 3] & 0xFF | (tmp[idx + 2] & 0xFF) << 8 | (tmp[idx + 1] & 0xFF) << 16 | (tmp[idx] & 0xFF) << 24;
                storage[i] = Float.intBitsToFloat(v);
                ++i;
                idx += 4;
            }
        }
    }

    @Override
    public void readArrayChar(int size, char[] storage) throws IOException {
        size = size / 2 + size % 2;
        if (this.littleEndian) {
            for (int i = 0; i < size; ++i) {
                storage[i] = (char)Short.reverseBytes(this.input.readShort());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                storage[i] = (char)this.input.readShort();
            }
        }
    }

    @Override
    public void readArrayByte(int size, byte[] storage) throws IOException {
        this.input.readFully(storage, 0, size);
    }
}

